/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.internal.FacesConfigDescriptor;
import com.liferay.faces.util.config.internal.Ordering;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;

public class OrderingCircularDependencyException
extends Exception {
    private static final long serialVersionUID = 6848057442511766527L;

    public OrderingCircularDependencyException(Ordering.Path path, List<FacesConfigDescriptor> facesConfigs) {
        super(OrderingCircularDependencyException.createMessage(path, facesConfigs));
    }

    private static String createMessage(Ordering.Path path, List<FacesConfigDescriptor> facesConfigs) {
        StringBuilder message = new StringBuilder();
        message.append("Circular dependencies detected when traversing '");
        message.append(path.name());
        message.append("' declarations:");
        for (FacesConfigDescriptor facesConfigDescriptor : facesConfigs) {
            Ordering someOrdering = facesConfigDescriptor.getOrdering();
            EnumMap<Ordering.Path, String[]> someRoutes = someOrdering.getRoutes();
            String[] someNames = someRoutes.get((Object)path);
            if (someNames.length == 0) continue;
            message.append(" ");
            message.append(facesConfigDescriptor.getName());
            message.append(" ");
            message.append(path.name());
            message.append(": ");
            message.append(Arrays.asList(someNames).toString());
            message.append("\n");
        }
        return message.toString();
    }
}

