/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.ConfiguredServlet;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.FacesConfig;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.internal.ConfiguredServletMappingImpl;
import com.liferay.faces.util.config.internal.FacesConfigDescriptor;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorParser;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorParserImpl;
import com.liferay.faces.util.config.internal.FacesConfigImpl;
import com.liferay.faces.util.config.internal.FacesConfigParser;
import com.liferay.faces.util.config.internal.FacesConfigParserImpl;
import com.liferay.faces.util.config.internal.FacesConfigScanner;
import com.liferay.faces.util.config.internal.OrderingUtil;
import com.liferay.faces.util.internal.CloseableUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.internal.ProductMojarraImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;
import javax.xml.parsers.SAXParser;

public abstract class FacesConfigScannerBase
implements FacesConfigScanner {
    private static final Logger logger = LoggerFactory.getLogger(FacesConfigScannerBase.class);
    public static final String MOJARRA_CONFIG_PATH = "com/sun/faces/jsf-ri-runtime.xml";
    protected static final String FACES_CONFIG_WEB_INF_PATH = "/WEB-INF/faces-config.xml";
    protected static final String FACES_SERVLET = "Faces Servlet";
    protected static final String FACES_SERVLET_FQCN = FacesServlet.class.getName();
    private ClassLoader classLoader;
    private boolean resolveEntities;
    private SAXParser saxParser;
    private WebConfig webConfig;

    public FacesConfigScannerBase(ClassLoader classLoader, SAXParser saxParser, boolean resolveEntities, WebConfig webConfig) {
        this.classLoader = classLoader;
        this.saxParser = saxParser;
        this.resolveEntities = resolveEntities;
        this.webConfig = webConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public FacesConfig scan() throws IOException {
        void var5_10;
        String string;
        List<ConfiguredServletMapping> configuredServletMappings;
        String configuredFacesServletName = FACES_SERVLET;
        ArrayList<ConfiguredServletMapping> facesServletMappings = new ArrayList<ConfiguredServletMapping>();
        List<ConfiguredServlet> configuredServlets = this.webConfig.getConfiguredServlets();
        if (configuredServlets != null) {
            for (ConfiguredServlet configuredServlet : configuredServlets) {
                if (!FACES_SERVLET_FQCN.equals(configuredServlet.getServletClass())) continue;
                configuredFacesServletName = configuredServlet.getServletName();
                break;
            }
        }
        if ((configuredServletMappings = this.webConfig.getConfiguredServletMappings()) != null) {
            for (ConfiguredServletMapping configuredServletMapping : configuredServletMappings) {
                if (!configuredFacesServletName.equals(configuredServletMapping.getServletName())) continue;
                facesServletMappings.add(configuredServletMapping);
            }
        }
        if ((string = this.webConfig.getConfiguredContextParams().get("javax.faces.DEFAULT_SUFFIX")) == null) {
            String string2 = ".xhtml .view.xml .jsp";
        }
        List<String> configuredSuffixes = Arrays.asList(var5_10.split(" "));
        for (String configuredSuffix : configuredSuffixes) {
            boolean found = false;
            for (ConfiguredServletMapping explicitFacesServletMapping : facesServletMappings) {
                if (!explicitFacesServletMapping.isExtensionMapped() || !explicitFacesServletMapping.getExtension().equals(configuredSuffix)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String urlPattern = "*" + configuredSuffix;
            ConfiguredServletMappingImpl implicitFacesServletMapping = new ConfiguredServletMappingImpl(FACES_SERVLET, urlPattern, true);
            facesServletMappings.add(implicitFacesServletMapping);
            logger.debug("Added implicit extension-mapped servlet-mapping for urlPattern=[{0}]", urlPattern);
        }
        FacesConfig facesConfig = new FacesConfigImpl(facesServletMappings, configuredSuffixes);
        InputStream inputStream = null;
        try {
            FacesConfigDescriptor mojarraConfigDescriptor = null;
            FacesConfigDescriptor webInfFacesConfigDescriptor = null;
            FacesConfigDescriptorParser facesConfigDescriptorParser = this.newFacesConfigDescriptorParser();
            FacesConfigParser facesConfigParser = this.newFacesConfigParser();
            List<URL> facesConfigURLs = this.getFacesConfigURLs(this.classLoader, FacesContext.getCurrentInstance());
            ArrayList<FacesConfigDescriptor> facesConfigDescriptors = new ArrayList<FacesConfigDescriptor>();
            for (URL facesConfigURL : facesConfigURLs) {
                logger.debug("Pre-processing faces-config: [{0}]", facesConfigURL);
                inputStream = facesConfigURL.openStream();
                String facesConfigPath = facesConfigURL.getPath();
                if (facesConfigPath.endsWith(MOJARRA_CONFIG_PATH)) {
                    mojarraConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, facesConfigURL);
                } else if (facesConfigPath.endsWith(FACES_CONFIG_WEB_INF_PATH)) {
                    webInfFacesConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, facesConfigURL);
                } else {
                    FacesConfigDescriptor facesConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, facesConfigURL);
                    facesConfigDescriptors.add(facesConfigDescriptor);
                }
                inputStream.close();
            }
            boolean MOJARRA_DETECTED = new ProductMojarraImpl().isDetected();
            if (MOJARRA_DETECTED && mojarraConfigDescriptor == null) {
                logger.warn("{0} not found.", MOJARRA_CONFIG_PATH);
            }
            List<FacesConfigDescriptor> orderedConfigs = OrderingUtil.getOrderedFacesConfigDescriptors(mojarraConfigDescriptor, facesConfigDescriptors, webInfFacesConfigDescriptor);
            for (FacesConfigDescriptor config : orderedConfigs) {
                String urlString = config.getURL();
                URL url = new URL(urlString);
                logger.debug("Post-processing faces-config: [{0}]", url);
                inputStream = url.openStream();
                try {
                    if (urlString.contains(MOJARRA_CONFIG_PATH)) {
                        FacesConfigParserImpl mojarraConfigParser = new FacesConfigParserImpl(this.saxParser, this.resolveEntities);
                        mojarraConfigParser.parse(inputStream, facesConfig);
                    } else {
                        facesConfig = facesConfigParser.parse(inputStream, facesConfig);
                    }
                }
                catch (IOException e) {
                    logger.error(e);
                }
                inputStream.close();
                try {
                    this.saxParser.reset();
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
            CloseableUtil.close(inputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            CloseableUtil.close(inputStream);
        }
        return facesConfig;
    }

    protected abstract List<URL> getFacesConfigURLs(ClassLoader var1, FacesContext var2) throws IOException;

    protected FacesConfigDescriptorParser newFacesConfigDescriptorParser() {
        return new FacesConfigDescriptorParserImpl(this.saxParser, this.resolveEntities);
    }

    protected FacesConfigParser newFacesConfigParser() {
        return new FacesConfigParserImpl(this.saxParser, this.resolveEntities);
    }
}

