/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.config.FacesConfig;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.internal.ApplicationConfigImpl;
import com.liferay.faces.util.config.internal.ApplicationConfigInitializer;
import com.liferay.faces.util.config.internal.FacesConfigScanner;
import com.liferay.faces.util.config.internal.FacesConfigScannerImpl;
import com.liferay.faces.util.config.internal.ResourceReader;
import com.liferay.faces.util.config.internal.ResourceReaderImpl;
import com.liferay.faces.util.config.internal.WebConfigScanner;
import com.liferay.faces.util.config.internal.WebConfigScannerImpl;
import com.liferay.faces.util.internal.TCCLUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.FacesConfigScannerOSGiImpl;
import com.liferay.faces.util.osgi.internal.OSGiEnvironment;
import com.liferay.faces.util.xml.ConcurrentSAXParserFactory;
import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

public class ApplicationConfigInitializerImpl
implements ApplicationConfigInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationConfigInitializerImpl.class);
    private String contextPath;
    private boolean resolveEntities;

    public ApplicationConfigInitializerImpl(String contextPath, boolean resolveEntities) {
        this.contextPath = contextPath;
        this.resolveEntities = resolveEntities;
    }

    @Override
    public ApplicationConfig initialize() throws IOException {
        ClassLoader classLoader = TCCLUtil.getThreadContextClassLoaderOrDefault(this.getClass());
        ResourceReader resourceReader = this.newResourceReader();
        SAXParserFactory saxParserFactory = ConcurrentSAXParserFactory.newInstance();
        saxParserFactory.setValidating(false);
        saxParserFactory.setNamespaceAware(true);
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            WebConfigScanner webConfigScanner = this.newWebConfigScanner(classLoader, resourceReader, saxParser, this.resolveEntities);
            WebConfig webConfig = webConfigScanner.scan();
            FacesConfigScanner facesConfigScanner = this.newFacesConfigScanner(classLoader, resourceReader, saxParser, this.resolveEntities, webConfig);
            FacesConfig facesConfig = facesConfigScanner.scan();
            return new ApplicationConfigImpl(this.contextPath, facesConfig, webConfig);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected FacesConfigScanner newFacesConfigScanner(ClassLoader classLoader, ResourceReader resourceReader, SAXParser saxParser, boolean resolveEntities, WebConfig webConfig) {
        if (OSGiEnvironment.isApiDetected()) {
            return new FacesConfigScannerOSGiImpl(classLoader, saxParser, resolveEntities, webConfig);
        }
        return new FacesConfigScannerImpl(classLoader, saxParser, resolveEntities, webConfig);
    }

    protected ResourceReader newResourceReader() {
        FacesContext startupFacesContext = FacesContext.getCurrentInstance();
        ExternalContext startupExternalContext = startupFacesContext.getExternalContext();
        return new ResourceReaderImpl(startupExternalContext);
    }

    protected WebConfigScanner newWebConfigScanner(ClassLoader classLoader, ResourceReader resourceReader, SAXParser saxParser, boolean resolveEntities) {
        return new WebConfigScannerImpl(classLoader, resourceReader, saxParser, resolveEntities);
    }
}

