/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.xml.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXHandlerBase
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(SAXHandlerBase.class);
    protected StringBuilder content;
    private boolean resolveEntities;
    private URL url;

    public SAXHandlerBase(boolean resolveEntities) {
        this.resolveEntities = resolveEntities;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.content != null && ch != null && length > 0) {
            this.content.append(ch, start, length);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        InputSource inputSource = new InputSource(new StringReader(""));
        if (this.resolveEntities && (inputSource = super.resolveEntity(publicId, systemId)) == null) {
            try {
                inputSource = new InputSource(new URL(systemId).openStream());
            }
            catch (IOException ioException) {
                logger.trace("Unable to download publicId=[{0}], systemId=[{1}], referenced-in=[{2}]", publicId, systemId, this.url);
            }
        }
        return inputSource;
    }
}

