/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.render;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class IdResponseWriter
extends ResponseWriterWrapper {
    private String idElement;
    private String idValue;
    private boolean writingIdElement;
    private ResponseWriter wrappedResponseWriter;

    public IdResponseWriter(ResponseWriter responseWriter, String idElement, String idValue) {
        this.wrappedResponseWriter = responseWriter;
        this.idElement = idElement;
        this.idValue = idValue;
    }

    public void endElement(String name) throws IOException {
        super.endElement(name);
        if (this.writingIdElement && this.idElement.equals(name)) {
            this.writingIdElement = false;
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        super.startElement(name, component);
        if (!this.writingIdElement && this.idElement != null && this.idElement.equals(name)) {
            this.writingIdElement = true;
            super.writeAttribute("id", (Object)this.idValue, "id");
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if ("id".equals(name)) {
            if (!this.writingIdElement) {
                super.writeAttribute(name, value, property);
            }
        } else {
            super.writeAttribute(name, value, property);
        }
    }
}

