/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.product.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.internal.ProductBase;
import com.liferay.faces.util.product.internal.ProductInfo;

public class ProductPortletApiImpl
extends ProductBase {
    private static final Logger logger = LoggerFactory.getLogger(ProductPortletApiImpl.class);

    public ProductPortletApiImpl(Product liferayPortal, Product pluto) {
        super(ProductPortletApiImpl.newInstance(liferayPortal, pluto));
    }

    private static ProductInfo newInstance(Product liferayPortal, Product pluto) {
        ProductInfo productInfo = null;
        String title = "Portlet API";
        int liferayPortalMajorVersion = liferayPortal.getMajorVersion();
        int liferayPortalMinorVersion = liferayPortal.getMinorVersion();
        boolean liferayPortalDetected = liferayPortal.isDetected();
        if (liferayPortalDetected && liferayPortalMajorVersion == 6 && liferayPortalMinorVersion == 2 && liferayPortal.getPatchVersion() < 5 || pluto.isDetected() && pluto.getMajorVersion() == 2 && pluto.getMinorVersion() == 0) {
            productInfo = new ProductInfo(true, title, "2.0");
        } else {
            try {
                productInfo = ProductInfo.newInstance(title, "javax.portlet.PortletContext", false);
                if (liferayPortalDetected) {
                    boolean liferay_7_0_detected;
                    boolean bl = liferay_7_0_detected = liferayPortalMajorVersion == 7 && liferayPortalMinorVersion == 0;
                    if (liferay_7_0_detected || liferayPortalMajorVersion == 6) {
                        if (productInfo.majorVersion == 0) {
                            productInfo = new ProductInfo(productInfo.detected, productInfo.title, "2.0");
                        } else if (liferay_7_0_detected && productInfo.majorVersion == 1) {
                            productInfo = new ProductInfo(productInfo.detected, productInfo.title, "2.1.0");
                        }
                    } else {
                        productInfo = new ProductInfo(productInfo.detected, productInfo.title, "3.0");
                    }
                }
                if (productInfo.majorVersion == 0) {
                    logger.warn("Unable to obtain version information for {0}.", productInfo.title);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (productInfo == null) {
            productInfo = new ProductInfo(false, title);
        }
        return productInfo;
    }
}

