/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.product.internal;

import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.internal.TCCLUtil;
import com.liferay.faces.util.product.internal.ProductBase;
import com.liferay.faces.util.product.internal.ProductInfo;

public class ProductICEfacesImpl
extends ProductBase {
    public ProductICEfacesImpl() {
        super(ProductICEfacesImpl.newInstance());
    }

    private static ProductInfo newInstance() {
        ProductInfo productInfo = null;
        try {
            Class<?> productInfoClass;
            try {
                productInfoClass = TCCLUtil.loadClassFromContext(ProductICEfacesImpl.class, "org.icefaces.application.ProductInfo");
            }
            catch (ClassNotFoundException e) {
                productInfoClass = TCCLUtil.loadClassFromContext(ProductICEfacesImpl.class, "com.icesoft.faces.application.ProductInfo");
            }
            int buildId = IntegerHelper.toInteger((String)productInfoClass.getDeclaredField("REVISION").get(String.class));
            int majorVersion = IntegerHelper.toInteger((String)productInfoClass.getDeclaredField("PRIMARY").get(String.class));
            int minorVersion = IntegerHelper.toInteger((String)productInfoClass.getDeclaredField("SECONDARY").get(String.class));
            int patchVersion = IntegerHelper.toInteger((String)productInfoClass.getDeclaredField("TERTIARY").get(String.class));
            String title = (String)productInfoClass.getDeclaredField("PRODUCT").get(String.class);
            if (title == null) {
                title = "ICEfaces";
            }
            boolean detected = false;
            if (majorVersion > 0) {
                detected = true;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(majorVersion);
            buf.append(".");
            buf.append(minorVersion);
            buf.append(".");
            buf.append(patchVersion);
            String version = buf.toString();
            productInfo = new ProductInfo(detected, title, version, majorVersion, minorVersion, patchVersion, buildId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (productInfo == null) {
            productInfo = new ProductInfo(false, "ICEfaces");
        }
        return productInfo;
    }
}

