/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.logging.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.logging.internal.LoggerDefaultImpl;
import com.liferay.faces.util.logging.internal.LoggerLog4JImpl;

public class LoggerFactoryImpl
extends LoggerFactory {
    private static final String CLASS_NAME_LOG4J_LOGGER = "org.apache.log4j.Logger";
    private static final boolean LOG4J_AVAILABLE;

    @Override
    public Logger getLoggerImplementation(String name) {
        if (LOG4J_AVAILABLE) {
            return new LoggerLog4JImpl(name);
        }
        return new LoggerDefaultImpl(name);
    }

    static {
        boolean log4jAvailable;
        try {
            Class.forName(CLASS_NAME_LOG4J_LOGGER);
            log4jAvailable = true;
            try {
                new LoggerLog4JImpl(CLASS_NAME_LOG4J_LOGGER);
            }
            catch (NoClassDefFoundError e) {
                System.err.println(LoggerFactory.class.getName() + " (WARN): Incompatible version of log4j.jar in the classpath. If you are using JBoss/Wildfly Server, add WEB-INF/lib/log4j.jar to activate Log4J logging.");
                System.err.println(e.getMessage());
                log4jAvailable = false;
            }
        }
        catch (Exception e) {
            log4jAvailable = false;
        }
        LOG4J_AVAILABLE = log4jAvailable;
    }
}

