/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.el.internal;

import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.cache.CacheFactory;
import com.liferay.faces.util.config.WebConfigParam;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class I18nMap
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = 5549598732411060854L;
    private static final Logger logger = LoggerFactory.getLogger(I18nMap.class);

    public static void initMessageCache(FacesContext facesContext) {
        if (!facesContext.isProjectStage(ProjectStage.Development)) {
            ExternalContext externalContext = facesContext.getExternalContext();
            int initialCacheCapacity = WebConfigParam.I18nELMapInitialCacheCapacity.getIntegerValue(externalContext);
            int maxCacheCapacity = WebConfigParam.I18nELMapMaxCacheCapacity.getIntegerValue(externalContext);
            Cache messageCache = maxCacheCapacity > -1 ? CacheFactory.getConcurrentLRUCacheInstance(externalContext, initialCacheCapacity, maxCacheCapacity) : CacheFactory.getConcurrentCacheInstance(externalContext, initialCacheCapacity);
            Map applicationMap = externalContext.getApplicationMap();
            applicationMap.put(I18nMap.class.getName(), messageCache);
        }
    }

    private static Cache<String, String> getMessageCache(ExternalContext externalContext) {
        Map applicationMap = externalContext.getApplicationMap();
        return (Cache)applicationMap.get(I18nMap.class.getName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        String message = null;
        if (key != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIViewRoot viewRoot = facesContext.getViewRoot();
            Locale locale = viewRoot.getLocale();
            if (locale == null) {
                Application application = facesContext.getApplication();
                locale = application.getDefaultLocale();
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            I18n i18n = I18nFactory.getI18nInstance(externalContext);
            String keyAsString = key.toString();
            Cache<String, String> messageCache = I18nMap.getMessageCache(externalContext);
            if (messageCache != null) {
                String messageKey = keyAsString;
                if (locale != null) {
                    messageKey = locale.toString().concat(keyAsString);
                }
                if ((message = messageCache.getValue(messageKey)) == null && (message = i18n.getMessage(facesContext, locale, keyAsString)) != null) {
                    message = messageCache.putValueIfAbsent(messageKey, message);
                }
            } else {
                message = i18n.getMessage(facesContext, locale, keyAsString);
            }
        }
        return message;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String replace(String messageId, String arg1) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            Application application = facesContext.getApplication();
            locale = application.getDefaultLocale();
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        I18n i18n = I18nFactory.getI18nInstance(externalContext);
        return i18n.getMessage(facesContext, locale, messageId, arg1);
    }

    public String replace(String messageId, String arg1, String arg2) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            Application application = facesContext.getApplication();
            locale = application.getDefaultLocale();
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        I18n i18n = I18nFactory.getI18nInstance(externalContext);
        return i18n.getMessage(facesContext, locale, messageId, arg1, arg2);
    }

    public String replace(String messageId, String arg1, String arg2, String arg3) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            Application application = facesContext.getApplication();
            locale = application.getDefaultLocale();
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        I18n i18n = I18nFactory.getI18nInstance(externalContext);
        return i18n.getMessage(facesContext, locale, messageId, arg1, arg2, arg3);
    }

    public String replace(String messageId, String arg1, String arg2, String arg3, String arg4) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            Application application = facesContext.getApplication();
            locale = application.getDefaultLocale();
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        I18n i18n = I18nFactory.getI18nInstance(externalContext);
        return i18n.getMessage(facesContext, locale, messageId, arg1, arg2, arg3, arg4);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }
}

