/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.el;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.beans.FeatureDescriptor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;

public abstract class ELResolverBase
extends ELResolver
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ELResolverBase.class);
    private static final long serialVersionUID = 8075201303544048292L;
    private final List<FeatureDescriptor> featureDescriptors;

    public ELResolverBase() {
        this.featureDescriptors = Collections.emptyList();
    }

    protected ELResolverBase(FeatureDescriptor ... featureDescriptors) {
        this.featureDescriptors = Collections.unmodifiableList(Arrays.asList(featureDescriptors));
    }

    @Deprecated
    protected static void addFeatureDescriptor(String featureName, Class<?> classType) {
        logger.warn("Ignoring static call to addFeatureDescriptor(). To add feature descriptors use the protected constructor instead.");
    }

    protected static FeatureDescriptor newFeatureDescriptor(String featureName, Class<?> classType) {
        FeatureDescriptor featureDescriptor = new FeatureDescriptor();
        featureDescriptor.setName(featureName);
        featureDescriptor.setDisplayName(featureName);
        featureDescriptor.setShortDescription(featureName);
        featureDescriptor.setExpert(false);
        featureDescriptor.setHidden(false);
        featureDescriptor.setPreferred(true);
        featureDescriptor.setValue("type", classType);
        featureDescriptor.setValue("resolvableAtDesignTime", true);
        return featureDescriptor;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        return this.featureDescriptors.iterator();
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException("elContext may not be null");
        }
        return String.class;
    }

    public Object getValue(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException("invalid ELContext");
        }
        Object value = null;
        if (base == null) {
            if (property instanceof String) {
                String varName = (String)property;
                value = this.resolveVariable(elContext, varName);
            }
        } else if (property instanceof String) {
            String propertyName = (String)property;
            value = this.resolveProperty(elContext, base, propertyName);
        }
        if (value != null) {
            elContext.setPropertyResolved(true);
        }
        return value;
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        if (elContext == null) {
            throw new NullPointerException("elContext may not be null");
        }
    }

    protected abstract Object resolveProperty(ELContext var1, Object var2, String var3);

    protected abstract Object resolveVariable(ELContext var1, String var2);
}

