/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;

public class PartialViewContextOnChangeImpl
extends PartialViewContextWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PartialViewContextOnChangeImpl.class);
    private FacesContext facesContext;
    private PartialViewContext wrappedPartialViewContext;
    private Map<String, Object> valueMap;
    private Map<String, Boolean> validMap;

    public PartialViewContextOnChangeImpl(PartialViewContext partialViewContext, FacesContext facesContext) {
        this.wrappedPartialViewContext = partialViewContext;
        this.facesContext = facesContext;
        this.validMap = new HashMap<String, Boolean>();
        this.valueMap = new HashMap<String, Object>();
    }

    public PartialViewContext getWrapped() {
        return this.wrappedPartialViewContext;
    }

    public void processPartial(PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
            Collection renderIds = this.wrappedPartialViewContext.getExecuteIds();
            EnumSet<VisitHint> visitHints = EnumSet.of(VisitHint.EXECUTE_LIFECYCLE);
            VisitContext visitContext = visitContextFactory.getVisitContext(this.facesContext, renderIds, visitHints);
            VisitCallbackApplyRequestValuesImpl visitCallback = new VisitCallbackApplyRequestValuesImpl(this.valueMap, this.validMap);
            this.facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
            Collection renderIds = this.wrappedPartialViewContext.getExecuteIds();
            EnumSet<VisitHint> visitHints = EnumSet.of(VisitHint.EXECUTE_LIFECYCLE);
            VisitContext visitContext = visitContextFactory.getVisitContext(this.facesContext, renderIds, visitHints);
            VisitCallbackRenderResponseImpl visitCallback = new VisitCallbackRenderResponseImpl(this.facesContext, this.valueMap, this.validMap);
            this.facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
        }
        super.processPartial(phaseId);
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.wrappedPartialViewContext.setPartialRequest(isPartialRequest);
    }

    private static final class VisitCallbackRenderResponseImpl
    implements VisitCallback {
        private FacesContext facesContext;
        private Map<String, Object> valueMap;
        private Map<String, Boolean> validMap;

        public VisitCallbackRenderResponseImpl(FacesContext facesContext, Map<String, Object> valueMap, Map<String, Boolean> validMap) {
            this.facesContext = facesContext;
            this.validMap = validMap;
            this.valueMap = valueMap;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            if (uiComponent instanceof EditableValueHolder) {
                EditableValueHolder editableValueHolder = (EditableValueHolder)uiComponent;
                uiComponent.pushComponentToEL(this.facesContext, uiComponent);
                boolean required = editableValueHolder.isRequired();
                uiComponent.popComponentFromEL(this.facesContext);
                if (required) {
                    List messageList;
                    String clientId = uiComponent.getClientId();
                    Object previousValue = this.valueMap.get(clientId);
                    Object submittedValue = editableValueHolder.getSubmittedValue();
                    boolean submittedValueEmpty = submittedValue == null || "".equals(submittedValue);
                    boolean previouslyValid = this.validMap.get(clientId);
                    logger.debug("previousValue=[{0}] submittedValue=[{1}] submittedValueEmpty=[{2}] previouslyValid=[{3}]", previousValue, submittedValue, submittedValueEmpty, previouslyValid);
                    if (previousValue == null && submittedValueEmpty && previouslyValid && (messageList = this.facesContext.getMessageList(clientId)) != null) {
                        ArrayList facesMessagesForClientId = new ArrayList(messageList);
                        for (FacesMessage facesMessage : facesMessagesForClientId) {
                            Iterator allFacesMessagesItr = this.facesContext.getMessages();
                            while (allFacesMessagesItr.hasNext()) {
                                FacesMessage curFacesMessage = (FacesMessage)allFacesMessagesItr.next();
                                if (!facesMessage.equals(curFacesMessage)) continue;
                                allFacesMessagesItr.remove();
                                editableValueHolder.setValid(true);
                                if (!logger.isDebugEnabled()) continue;
                                String summary = facesMessage.getSummary();
                                logger.debug("Removed facesMessage summary=[{0}] for clientId=[{1}]", summary, clientId);
                            }
                        }
                    }
                }
            }
            return VisitResult.ACCEPT;
        }
    }

    private static final class VisitCallbackApplyRequestValuesImpl
    implements VisitCallback {
        private Map<String, Object> valueMap;
        private Map<String, Boolean> validMap;

        public VisitCallbackApplyRequestValuesImpl(Map<String, Object> valueMap, Map<String, Boolean> validMap) {
            this.validMap = validMap;
            this.valueMap = valueMap;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            if (uiComponent instanceof EditableValueHolder) {
                EditableValueHolder editableValueHolder = (EditableValueHolder)uiComponent;
                String clientId = uiComponent.getClientId();
                this.validMap.put(clientId, editableValueHolder.isValid());
                this.valueMap.put(clientId, editableValueHolder.getValue());
            }
            return VisitResult.ACCEPT;
        }
    }
}

