/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.internal.Ordering;
import java.util.Arrays;
import java.util.EnumMap;

public class OrderingImpl
implements Ordering {
    private EnumMap<Ordering.Path, String[]> routes = new EnumMap(Ordering.Path.class);

    public OrderingImpl() {
        this.routes.put(Ordering.Path.BEFORE, new String[0]);
        this.routes.put(Ordering.Path.AFTER, new String[0]);
    }

    @Override
    public EnumMap<Ordering.Path, String[]> getRoutes() {
        return this.routes;
    }

    @Override
    public boolean isAfter(String name) {
        return Arrays.binarySearch(this.routes.get((Object)Ordering.Path.AFTER), name) >= 0;
    }

    @Override
    public boolean isAfterOthers() {
        boolean value = false;
        if (this.routes.get((Object)Ordering.Path.AFTER) != null) {
            value = Arrays.binarySearch(this.routes.get((Object)Ordering.Path.AFTER), OTHERS) >= 0;
        }
        return value;
    }

    @Override
    public boolean isBefore(String name) {
        return Arrays.binarySearch(this.routes.get((Object)Ordering.Path.BEFORE), name) >= 0;
    }

    @Override
    public boolean isBeforeOthers() {
        boolean value = false;
        if (this.routes.get((Object)Ordering.Path.BEFORE) != null) {
            value = Arrays.binarySearch(this.routes.get((Object)Ordering.Path.BEFORE), OTHERS) >= 0;
        }
        return value;
    }

    @Override
    public boolean isOrdered() {
        return this.routes.get((Object)Ordering.Path.BEFORE).length != 0 || this.routes.get((Object)Ordering.Path.AFTER).length != 0;
    }

    @Override
    public void setRoutes(EnumMap<Ordering.Path, String[]> routes) {
        this.routes = routes;
    }
}

