/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.ConfiguredElement;
import com.liferay.faces.util.config.ConfiguredManagedBean;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.ConfiguredSystemEventListener;
import com.liferay.faces.util.config.FacesConfig;
import com.liferay.faces.util.config.internal.ConfiguredElementImpl;
import com.liferay.faces.util.config.internal.ConfiguredManagedBeanImpl;
import com.liferay.faces.util.config.internal.ConfiguredSystemEventListenerImpl;
import com.liferay.faces.util.config.internal.FacesConfigImpl;
import com.liferay.faces.util.config.internal.FacesConfigParser;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.xml.internal.SAXHandlerBase;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacesConfigParserImpl
extends SAXHandlerBase
implements FacesConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(FacesConfigParserImpl.class);
    private static final String APPLICATION_EXTENSION = "application-extension";
    private static final String FACTORY_EXTENSION = "factory-extension";
    private static final String MANAGED_BEAN_CLASS = "managed-bean-class";
    private static final String MANAGED_BEAN_NAME = "managed-bean-name";
    private static final String MANAGED_BEAN_SCOPE = "managed-bean-scope";
    private static final String SOURCE_CLASS = "source-class";
    private static final String SYSTEM_EVENT_CLASS = "system-event-class";
    private static final String SYSTEM_EVENT_LISTENER = "system-event-listener";
    private static final String SYSTEM_EVENT_LISTENER_CLASS = "system-event-listener-class";
    private List<ConfiguredElement> configuredApplicationExtensions;
    private List<ConfiguredElement> configuredFactoryExtensions;
    private List<ConfiguredServletMapping> configuredFacesServletMappings;
    private List<ConfiguredManagedBean> configuredManagedBeans;
    private List<String> configuredSuffixes;
    private List<ConfiguredSystemEventListener> configuredSystemEventListeners;
    private String managedBeanClass;
    private String managedBeanName;
    private boolean parsingApplicationExtension;
    private boolean parsingFactoryExtension;
    private boolean parsingManagedBeanClass;
    private boolean parsingManagedBeanName;
    private boolean parsingManagedBeanScope;
    private boolean parsingSourceClass;
    private boolean parsingSystemEventClass;
    private boolean parsingSystemEventListener;
    private boolean parsingSystemEventListenerClass;
    private SAXParser saxParser;
    private String sourceClass;
    private String systemEventClass;
    private String systemEventListenerClass;

    public FacesConfigParserImpl(SAXParser saxParser, boolean resolveEntities) {
        super(resolveEntities);
        this.saxParser = saxParser;
    }

    @Override
    public void endElement(String uri, String localName, String elementName) throws SAXException {
        if (this.parsingApplicationExtension) {
            if (localName.equals(APPLICATION_EXTENSION)) {
                this.parsingApplicationExtension = false;
            } else if (this.parsingSourceClass) {
                this.sourceClass = this.content.toString().trim();
                this.parsingSourceClass = false;
            } else if (this.parsingSystemEventClass) {
                this.systemEventClass = this.content.toString().trim();
                this.parsingSystemEventClass = false;
            } else if (this.parsingSystemEventListenerClass) {
                this.systemEventListenerClass = this.content.toString().trim();
                this.parsingSystemEventListenerClass = false;
            } else if (this.parsingSystemEventListener) {
                ConfiguredSystemEventListenerImpl configuredSystemEventListener = new ConfiguredSystemEventListenerImpl(this.sourceClass, this.systemEventClass, this.systemEventListenerClass);
                this.configuredSystemEventListeners.add(configuredSystemEventListener);
                this.parsingSystemEventListener = false;
            } else {
                String elementValue = null;
                if (this.content != null) {
                    elementValue = this.content.toString().trim();
                }
                ConfiguredElementImpl configuredElement = new ConfiguredElementImpl(localName, elementValue);
                this.configuredApplicationExtensions.add(configuredElement);
            }
        } else if (this.parsingFactoryExtension) {
            if (localName.equals(FACTORY_EXTENSION)) {
                this.parsingFactoryExtension = false;
            } else {
                String factoryName = localName;
                String factoryClass = null;
                if (this.content != null) {
                    factoryClass = this.content.toString().trim();
                }
                ConfiguredElementImpl configuredElement = new ConfiguredElementImpl(factoryName, factoryClass);
                this.configuredFactoryExtensions.add(configuredElement);
            }
        } else if (this.parsingManagedBeanClass) {
            this.managedBeanClass = this.content.toString().trim();
            this.parsingManagedBeanClass = false;
        } else if (this.parsingManagedBeanName) {
            this.managedBeanName = this.content.toString().trim();
            this.parsingManagedBeanName = false;
        } else if (this.parsingManagedBeanScope) {
            String managedBeanScope = this.content.toString().trim();
            ConfiguredManagedBeanImpl configuredManagedBean = new ConfiguredManagedBeanImpl(this.managedBeanClass, this.managedBeanName, managedBeanScope);
            this.configuredManagedBeans.add(configuredManagedBean);
            this.parsingManagedBeanScope = false;
        } else if (this.parsingSourceClass) {
            this.sourceClass = this.content.toString().trim();
            this.parsingSourceClass = false;
        } else if (this.parsingSystemEventClass) {
            this.systemEventClass = this.content.toString().trim();
            this.parsingSystemEventClass = false;
        } else if (this.parsingSystemEventListenerClass) {
            this.systemEventListenerClass = this.content.toString().trim();
            this.parsingSystemEventListenerClass = false;
        } else if (this.parsingSystemEventListener) {
            ConfiguredSystemEventListenerImpl configuredSystemEventListener = new ConfiguredSystemEventListenerImpl(this.sourceClass, this.systemEventClass, this.systemEventListenerClass);
            this.configuredSystemEventListeners.add(configuredSystemEventListener);
            this.parsingSystemEventListener = false;
        } else {
            super.endElement(uri, localName, elementName);
        }
        this.content = null;
    }

    @Override
    public FacesConfig parse(InputStream inputStream, FacesConfig facesConfig) throws IOException {
        List<ConfiguredElement> configuredApplicationExtensions = facesConfig.getConfiguredApplicationExtensions();
        this.configuredApplicationExtensions = new ArrayList<ConfiguredElement>(configuredApplicationExtensions);
        List<ConfiguredElement> configuredFactoryExtensions = facesConfig.getConfiguredFactoryExtensions();
        this.configuredFactoryExtensions = new ArrayList<ConfiguredElement>(configuredFactoryExtensions);
        List<ConfiguredManagedBean> configuredManagedBeans = facesConfig.getConfiguredManagedBeans();
        this.configuredManagedBeans = new ArrayList<ConfiguredManagedBean>(configuredManagedBeans);
        this.configuredFacesServletMappings = facesConfig.getConfiguredFacesServletMappings();
        this.configuredSuffixes = facesConfig.getConfiguredSuffixes();
        List<ConfiguredSystemEventListener> configuredSystemEventListeners = facesConfig.getConfiguredSystemEventListeners();
        this.configuredSystemEventListeners = new ArrayList<ConfiguredSystemEventListener>(configuredSystemEventListeners);
        try {
            this.saxParser.parse(inputStream, (DefaultHandler)this);
            facesConfig = new FacesConfigImpl(this.configuredApplicationExtensions, this.configuredFactoryExtensions, this.configuredFacesServletMappings, this.configuredManagedBeans, this.configuredSuffixes, this.configuredSystemEventListeners);
            this.saxParser.reset();
            return facesConfig;
        }
        catch (SAXException e) {
            logger.error(e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        this.content = new StringBuilder();
        if (localName.equals(APPLICATION_EXTENSION)) {
            this.parsingApplicationExtension = true;
        } else if (localName.equals(FACTORY_EXTENSION)) {
            this.parsingFactoryExtension = true;
        } else if (localName.equals(MANAGED_BEAN_CLASS)) {
            this.parsingManagedBeanClass = true;
        } else if (localName.equals(MANAGED_BEAN_NAME)) {
            this.parsingManagedBeanName = true;
        } else if (localName.equals(MANAGED_BEAN_SCOPE)) {
            this.parsingManagedBeanScope = true;
        } else if (localName.equals(SOURCE_CLASS)) {
            this.parsingSourceClass = true;
        } else if (localName.equals(SYSTEM_EVENT_CLASS)) {
            this.parsingSystemEventClass = true;
        } else if (localName.equals(SYSTEM_EVENT_LISTENER)) {
            this.parsingSystemEventListener = true;
        } else if (localName.equals(SYSTEM_EVENT_LISTENER_CLASS)) {
            this.parsingSystemEventListenerClass = true;
        } else {
            super.startElement(uri, localName, elementName, attributes);
        }
    }

    protected SAXParser getSAXParser() {
        return this.saxParser;
    }
}

