/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config;

import com.liferay.faces.util.config.ConfigParam;
import com.liferay.faces.util.config.WebConfigParamUtil;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.i18n.I18n;
import javax.faces.context.ExternalContext;

public enum WebConfigParam implements ConfigParam<ExternalContext>
{
    I18nELMapInitialCacheCapacity("com.liferay.faces.util.el.i18n.INITIAL_CACHE_CAPACITY", 16),
    I18nInitialCacheCapacity(I18n.class.getName() + ".INITIAL_CACHE_CAPACITY", 16),
    I18nELMapMaxCacheCapacity("com.liferay.faces.util.el.i18n.MAX_CACHE_CAPACITY", -1),
    I18nMaxCacheCapacity(I18n.class.getName() + ".MAX_CACHE_CAPACITY", -1),
    ResolveXMLEntities("com.liferay.faces.util.resolveXMLEntities", "com.liferay.faces.bridge.resolveXMLEntities", false),
    UploadedFilesDir("com.liferay.faces.util.uploadedFilesDir", System.getProperty("java.io.tmpdir")),
    UploadedFileMaxSize("com.liferay.faces.util.uploadedFileMaxSize", 0x6400000);

    private String alternateName;
    private boolean defaultBooleanValue;
    private String defaultStringValue;
    private int defaultIntegerValue;
    private long defaultLongValue;
    private String name;

    private WebConfigParam(String name, String defaultStringValue) {
        this.name = name;
        if (BooleanHelper.isTrueToken(defaultStringValue)) {
            this.defaultBooleanValue = true;
            this.defaultIntegerValue = 1;
        } else {
            this.defaultBooleanValue = false;
            this.defaultIntegerValue = 0;
        }
        this.defaultStringValue = defaultStringValue;
    }

    private WebConfigParam(String name, int defaultIntegerValue) {
        this.name = name;
        this.defaultBooleanValue = defaultIntegerValue != 0;
        this.defaultIntegerValue = defaultIntegerValue;
        this.defaultLongValue = defaultIntegerValue;
        this.defaultStringValue = Integer.toString(defaultIntegerValue);
    }

    private WebConfigParam(String name, long defaultLongValue) {
        this.name = name;
        boolean bl = this.defaultBooleanValue = defaultLongValue != 0L;
        this.defaultIntegerValue = defaultLongValue < Integer.MIN_VALUE ? Integer.MIN_VALUE : (defaultLongValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)defaultLongValue);
        this.defaultLongValue = defaultLongValue;
        this.defaultStringValue = Long.toString(defaultLongValue);
    }

    private WebConfigParam(String name, String alternateName, boolean defaultBooleanValue) {
        this.name = name;
        this.alternateName = alternateName;
        if (defaultBooleanValue) {
            this.defaultBooleanValue = true;
            this.defaultIntegerValue = 1;
            this.defaultLongValue = 1L;
            this.defaultStringValue = Boolean.TRUE.toString();
        } else {
            this.defaultBooleanValue = false;
            this.defaultIntegerValue = 0;
            this.defaultLongValue = 0L;
            this.defaultStringValue = Boolean.FALSE.toString();
        }
    }

    @Override
    public String getAlternateName() {
        return this.alternateName;
    }

    @Override
    public boolean getBooleanValue(ExternalContext externalContext) {
        return WebConfigParamUtil.getBooleanValue(externalContext, this.name, this.alternateName, this.defaultBooleanValue);
    }

    @Override
    public String getConfiguredValue(ExternalContext externalContext) {
        return WebConfigParamUtil.getConfiguredValue(externalContext, this.name, this.alternateName);
    }

    @Override
    public boolean getDefaultBooleanValue() {
        return this.defaultBooleanValue;
    }

    @Override
    public int getDefaultIntegerValue() {
        return this.defaultIntegerValue;
    }

    @Override
    public long getDefaultLongValue() {
        return this.defaultLongValue;
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultStringValue;
    }

    @Override
    public int getIntegerValue(ExternalContext externalContext) {
        return WebConfigParamUtil.getIntegerValue(externalContext, this.name, this.alternateName, this.defaultIntegerValue);
    }

    @Override
    public long getLongValue(ExternalContext externalContext) {
        return WebConfigParamUtil.getLongValue(externalContext, this.name, this.alternateName, this.defaultLongValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStringValue(ExternalContext externalContext) {
        return WebConfigParamUtil.getStringValue(externalContext, this.name, this.alternateName, this.defaultStringValue);
    }

    @Override
    public boolean isConfigured(ExternalContext externalContext) {
        return WebConfigParamUtil.isSpecified(externalContext, this.name, this.alternateName);
    }
}

