/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.cache.internal;

import com.liferay.faces.util.cache.Cache;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentCacheImpl<K, V>
implements Cache<K, V>,
Serializable {
    private static final long serialVersionUID = 2468038135762834477L;
    private final ConcurrentHashMap<K, V> internalCache;

    public ConcurrentCacheImpl() {
        this.internalCache = new ConcurrentHashMap();
    }

    public ConcurrentCacheImpl(int initialCapacity) {
        this.internalCache = new ConcurrentHashMap(initialCapacity);
    }

    @Override
    public boolean containsKey(K key) {
        return this.internalCache.containsKey(key);
    }

    @Override
    public Set<K> getKeys() {
        return this.internalCache.keySet();
    }

    @Override
    public int getSize() {
        return this.internalCache.size();
    }

    @Override
    public V getValue(K key) {
        return this.internalCache.get(key);
    }

    @Override
    public V putValueIfAbsent(K key, V value) {
        V retValue = this.internalCache.putIfAbsent(key, value);
        if (retValue == null) {
            retValue = value;
        }
        return retValue;
    }

    @Override
    public V removeValue(K key) {
        return this.internalCache.remove(key);
    }
}

