/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.application;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.faces.component.UIComponent;

public final class ResourceUtil {
    private ResourceUtil() {
        throw new AssertionError();
    }

    public static String getResourceId(UIComponent componentResource) {
        String library = null;
        String name = null;
        if (componentResource != null) {
            Map componentResourceAttributes = componentResource.getAttributes();
            library = (String)componentResourceAttributes.get("library");
            name = (String)componentResourceAttributes.get("name");
        }
        return ResourceUtil.getResourceId(library, name);
    }

    public static String getResourceId(String library, String name) {
        String resourceDependencyId = library == null ? name : (name == null ? library : library.concat(":").concat(name));
        return resourceDependencyId;
    }

    public static InputStream toInputStream(String string, String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(string.getBytes(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream inputStream, String encoding, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, encoding);
            int charsRead = 0;
            while (charsRead != -1) {
                charsRead = inputStreamReader.read(buffer, 0, buffer.length);
                if (charsRead <= 0) continue;
                stringBuilder.append(buffer, 0, charsRead);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        return stringBuilder.toString();
    }
}

