/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.xml.internal;

import com.liferay.faces.util.xml.internal.AttributesImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XMLReaderImpl
implements XMLReader {
    private static final String XMLNS = "xmlns";
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private Map<String, Boolean> featureMap;
    private Map<String, Object> propertyMap;

    public XMLReaderImpl(Map<String, Boolean> featureMap) {
        this.featureMap = featureMap;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.featureMap.get(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.propertyMap.get(name);
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        InputStream byteStream;
        Reader reader = inputSource.getCharacterStream();
        if (reader == null && (byteStream = inputSource.getByteStream()) != null) {
            String encoding = inputSource.getEncoding();
            reader = encoding != null ? new InputStreamReader(byteStream, encoding) : new InputStreamReader(byteStream);
        }
        if (reader != null) {
            reader = new BufferedReader(reader);
            this.contentHandler.startDocument();
            this.parse(reader);
            this.contentHandler.endDocument();
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler != null && contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.featureMap.put(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.propertyMap.put(name, value);
    }

    protected Map<String, Object> getPropertyMap() {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, Object>();
        }
        return this.propertyMap;
    }

    protected void parse(Reader reader) throws IOException, SAXException {
        AttributesImpl attributes = null;
        StringBuilder attributeName = null;
        StringBuilder attributeValue = null;
        StringBuilder comment = null;
        StringBuilder elementName = null;
        boolean openQuote = false;
        boolean parsingAttributeName = false;
        boolean parsingAttributeValue = false;
        boolean parsingComment = false;
        boolean parsingDeclaration = false;
        boolean parsingElementName = false;
        boolean parsingText = false;
        StringBuilder text = null;
        HashMap<String, String> uriMap = new HashMap<String, String>();
        int prevChar1 = 65535;
        int prevChar2 = 65535;
        int prevChar3 = 65535;
        int characterAsInt = reader.read();
        while (characterAsInt != -1) {
            boolean parsingContent;
            char curChar = (char)characterAsInt;
            boolean bl = parsingContent = parsingAttributeValue || parsingComment || parsingText;
            if (curChar == '<') {
                if (parsingText) {
                    if (text.length() > 0) {
                        String value = text.toString();
                        this.contentHandler.characters(value.toCharArray(), 0, value.length());
                    }
                    parsingText = false;
                }
                parsingAttributeName = false;
                parsingElementName = true;
                elementName = new StringBuilder();
                attributes = new AttributesImpl();
            } else if (curChar == '>') {
                if (prevChar1 == 63 && parsingDeclaration) {
                    parsingDeclaration = false;
                } else if (parsingComment && prevChar1 == 45 && prevChar2 == 45) {
                    if (this.lexicalHandler != null) {
                        String commentText = comment.toString();
                        int pos = commentText.lastIndexOf("--");
                        if (pos > 0) {
                            commentText = commentText.substring(0, pos);
                        }
                        this.lexicalHandler.comment(commentText.toCharArray(), 0, commentText.length());
                    }
                    parsingComment = false;
                } else {
                    String uri = "";
                    String qName = elementName.toString();
                    boolean startElement = true;
                    boolean endElement = false;
                    if (qName.length() > 0 && qName.charAt(0) == '/') {
                        startElement = false;
                        endElement = true;
                        qName = qName.substring(1);
                    } else if (prevChar1 == 47) {
                        endElement = true;
                    }
                    String localName = qName;
                    String prefix = null;
                    int colonPos = localName.indexOf(58);
                    if (colonPos > 0) {
                        prefix = qName.substring(0, colonPos);
                        uri = (String)uriMap.get(prefix);
                        if (uri == null) {
                            uri = "";
                        }
                        localName = qName.substring(colonPos + 1);
                    }
                    if (startElement) {
                        this.contentHandler.startElement(uri, localName, qName, attributes);
                        parsingElementName = false;
                        parsingText = true;
                        parsingAttributeName = false;
                        parsingAttributeValue = false;
                        text = new StringBuilder();
                    }
                    if (endElement) {
                        this.contentHandler.endElement(uri, localName, qName);
                    }
                }
            } else if (curChar == '?' && !parsingContent) {
                if (prevChar1 == 60) {
                    parsingDeclaration = true;
                    parsingElementName = false;
                }
            } else if (Character.isWhitespace(curChar) && !parsingContent) {
                if (parsingElementName) {
                    parsingElementName = false;
                    parsingAttributeName = true;
                    attributeName = new StringBuilder();
                    attributeValue = new StringBuilder();
                }
            } else if (curChar == '=' && !parsingContent) {
                if (parsingAttributeName) {
                    parsingAttributeName = false;
                    parsingAttributeValue = true;
                }
            } else if (curChar == '-' && prevChar1 == 45 && prevChar2 == 33 && prevChar3 == 60) {
                parsingElementName = false;
                parsingComment = true;
                comment = new StringBuilder();
            } else {
                boolean ignore = false;
                if (curChar == '\"') {
                    boolean bl2 = openQuote = !openQuote;
                    if (parsingAttributeValue) {
                        ignore = true;
                        if (!openQuote) {
                            String qName;
                            parsingAttributeValue = false;
                            String uri = "";
                            String localName = qName = attributeName.toString().trim();
                            String prefix = null;
                            int colonPos = localName.indexOf(58);
                            if (colonPos > 0) {
                                prefix = qName.substring(0, colonPos);
                                uri = (String)uriMap.get(prefix);
                                if (uri == null) {
                                    uri = "";
                                }
                                localName = qName.substring(colonPos + 1);
                            }
                            String type = "ENTITY";
                            StringBuilder buf = null;
                            int ampersandPos = attributeValue.indexOf("&amp;");
                            if (ampersandPos > 0) {
                                int startPos = 0;
                                buf = new StringBuilder();
                                while (ampersandPos > 0) {
                                    buf.append(attributeValue.substring(startPos, ampersandPos));
                                    buf.append("&");
                                    startPos = ampersandPos + "&amp;".length();
                                    ampersandPos = attributeValue.indexOf("&amp;", startPos);
                                }
                                if (startPos < attributeValue.length()) {
                                    buf.append(attributeValue.substring(startPos));
                                }
                            } else {
                                buf = attributeValue;
                            }
                            String value = buf.toString();
                            attributes.add(uri, localName, qName, type, value);
                            if (qName.toLowerCase().startsWith(XMLNS)) {
                                if (localName.equals(XMLNS)) {
                                    localName = "";
                                }
                                uriMap.put(localName, value);
                            }
                            parsingAttributeName = true;
                            attributeName = new StringBuilder();
                            attributeValue = new StringBuilder();
                        }
                    }
                } else if (curChar != ' ' && Character.isWhitespace(curChar)) {
                    ignore = true;
                }
                if (!ignore) {
                    if (parsingAttributeName) {
                        attributeName.append(curChar);
                    } else if (parsingAttributeValue) {
                        attributeValue.append(curChar);
                    } else if (parsingComment) {
                        comment.append(curChar);
                    } else if (parsingElementName) {
                        elementName.append(curChar);
                    } else if (parsingText) {
                        text.append(curChar);
                    }
                }
            }
            prevChar3 = prevChar2;
            prevChar2 = prevChar1;
            prevChar1 = curChar;
            characterAsInt = reader.read();
        }
    }
}

