/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.render.internal;

import com.liferay.faces.util.application.ResourceVerifier;
import com.liferay.faces.util.application.ResourceVerifierFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import javax.faces.render.RendererWrapper;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class ResourceRendererUtilImpl
extends RendererWrapper
implements ComponentSystemEventListener,
StateHolder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRendererUtilImpl.class);
    private boolean transientFlag;
    private Renderer wrappedRenderer;

    public ResourceRendererUtilImpl() {
    }

    public ResourceRendererUtilImpl(Renderer wrappedRenderer) {
        this.wrappedRenderer = wrappedRenderer;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        ResourceVerifier resourceVerifier = ResourceVerifierFactory.getResourceVerifierInstance(externalContext);
        if (resourceVerifier.isDependencySatisfied(facesContext, uiComponent)) {
            if (logger.isDebugEnabled()) {
                Map componentResourceAttributes = uiComponent.getAttributes();
                logger.debug("Resource dependency already satisfied: name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", componentResourceAttributes.get("name"), componentResourceAttributes.get("library"), uiComponent.getRendererType(), this.getComponentValue(uiComponent), uiComponent.getClass().getName());
            }
        } else {
            super.encodeBegin(facesContext, uiComponent);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        ResourceVerifier resourceVerifier = ResourceVerifierFactory.getResourceVerifierInstance(externalContext);
        if (resourceVerifier.isDependencySatisfied(facesContext, uiComponent)) {
            if (logger.isDebugEnabled()) {
                Map componentResourceAttributes = uiComponent.getAttributes();
                logger.debug("Resource dependency already satisfied: name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", componentResourceAttributes.get("name"), componentResourceAttributes.get("library"), uiComponent.getRendererType(), this.getComponentValue(uiComponent), uiComponent.getClass().getName());
            }
        } else {
            super.encodeChildren(facesContext, uiComponent);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        ResourceVerifier resourceVerifier = ResourceVerifierFactory.getResourceVerifierInstance(externalContext);
        if (resourceVerifier.isDependencySatisfied(facesContext, uiComponent)) {
            if (logger.isDebugEnabled()) {
                Map componentResourceAttributes = uiComponent.getAttributes();
                logger.debug("Resource dependency already satisfied: name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", componentResourceAttributes.get("name"), componentResourceAttributes.get("library"), uiComponent.getRendererType(), this.getComponentValue(uiComponent), uiComponent.getClass().getName());
            }
        } else {
            super.encodeEnd(facesContext, uiComponent);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (this.wrappedRenderer instanceof ComponentSystemEventListener) {
            ComponentSystemEventListener wrappedListener = (ComponentSystemEventListener)this.wrappedRenderer;
            wrappedListener.processEvent(event);
        } else {
            logger.debug("Wrapped renderer=[{0}] does not implement ComponentSystemEventListener", this.wrappedRenderer);
        }
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (this.wrappedRenderer == null) {
            try {
                Class wrappedRendererClass = (Class)state;
                this.wrappedRenderer = (Renderer)wrappedRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    public Object saveState(FacesContext facesContext) {
        return this.wrappedRenderer.getClass();
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    private String getComponentValue(UIComponent componentResource) {
        ValueHolder valueHolder;
        Object valueAsObject;
        String componentResourceValue = null;
        if (componentResource instanceof ValueHolder && (valueAsObject = (valueHolder = (ValueHolder)componentResource).getValue()) != null) {
            componentResourceValue = valueAsObject.toString();
        }
        return componentResourceValue;
    }
}

