/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.render;

import com.liferay.faces.util.render.DelegatingRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;

public abstract class DelegatingRendererBase
extends Renderer
implements DelegatingRenderer {
    @Override
    public abstract String getDelegateComponentFamily();

    @Override
    public abstract String getDelegateRendererType();

    public String convertClientId(FacesContext facesContext, String clientId) {
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        return delegateRenderer.convertClientId(facesContext, clientId);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.decode(facesContext, uiComponent);
    }

    @Override
    public void encodeAll(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeBegin(facesContext, uiComponent);
        delegateRenderer.encodeChildren(facesContext, uiComponent);
        delegateRenderer.encodeEnd(facesContext, uiComponent);
    }

    @Override
    public void encodeAll(FacesContext facesContext, UIComponent uiComponent, ResponseWriter delegationResponseWriter) throws IOException {
        ResponseWriter originalResponseWriter = facesContext.getResponseWriter();
        facesContext.setResponseWriter(delegationResponseWriter);
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeBegin(facesContext, uiComponent);
        delegateRenderer.encodeChildren(facesContext, uiComponent);
        delegateRenderer.encodeEnd(facesContext, uiComponent);
        facesContext.setResponseWriter(originalResponseWriter);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeBegin(facesContext, uiComponent);
    }

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent, ResponseWriter delegationResponseWriter) throws IOException {
        ResponseWriter originalResponseWriter = facesContext.getResponseWriter();
        facesContext.setResponseWriter(delegationResponseWriter);
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeBegin(facesContext, uiComponent);
        facesContext.setResponseWriter(originalResponseWriter);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeChildren(facesContext, uiComponent);
    }

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent, ResponseWriter delegationResponseWriter) throws IOException {
        ResponseWriter originalResponseWriter = facesContext.getResponseWriter();
        facesContext.setResponseWriter(delegationResponseWriter);
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeChildren(facesContext, uiComponent);
        facesContext.setResponseWriter(originalResponseWriter);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeEnd(facesContext, uiComponent);
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent, ResponseWriter delegationResponseWriter) throws IOException {
        ResponseWriter originalResponseWriter = facesContext.getResponseWriter();
        facesContext.setResponseWriter(delegationResponseWriter);
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        delegateRenderer.encodeEnd(facesContext, uiComponent);
        facesContext.setResponseWriter(originalResponseWriter);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        Object convertedValue = delegateRenderer.getConvertedValue(facesContext, uiComponent, submittedValue);
        return convertedValue;
    }

    @Override
    public Renderer getDelegateRenderer(FacesContext facesContext) {
        RenderKit renderKit = facesContext.getRenderKit();
        Renderer delegateRenderer = renderKit.getRenderer(this.getDelegateComponentFamily(), this.getDelegateRendererType());
        return delegateRenderer;
    }

    public boolean getRendersChildren() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Renderer delegateRenderer = this.getDelegateRenderer(facesContext);
        return delegateRenderer.getRendersChildren();
    }
}

