/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.model.internal;

import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.model.UploadedFileFactory;
import com.liferay.faces.util.model.internal.UploadedFileErrorImpl;
import com.liferay.faces.util.model.internal.UploadedFileImpl;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.InvalidFileNameException;

public class UploadedFileFactoryImpl
extends UploadedFileFactory
implements Serializable {
    private static final long serialVersionUID = 1276552178390469143L;

    @Override
    public UploadedFile getUploadedFile(Exception e) {
        UploadedFile uploadedFile = e.getClass().getName().startsWith("org.apache.commons.fileupload.") ? CommonsFileUploadErrorUtil.getUploadedFile(e) : new UploadedFileErrorImpl(e);
        return uploadedFile;
    }

    @Override
    public UploadedFile getUploadedFile(Exception e, UploadedFile.Status uploadedFileStatus) {
        return new UploadedFileErrorImpl(e, uploadedFileStatus);
    }

    @Override
    public UploadedFile getUploadedFile(String absolutePath, Map<String, Object> attributes, String charSet, String contentType, Map<String, List<String>> headers, String id, String message, String name, long size, UploadedFile.Status status) {
        return new UploadedFileImpl(absolutePath, attributes, charSet, contentType, headers, id, message, name, size, status);
    }

    @Override
    public UploadedFileFactory getWrapped() {
        return null;
    }

    private static final class CommonsFileUploadErrorUtil {
        private CommonsFileUploadErrorUtil() {
            throw new AssertionError();
        }

        private static UploadedFile getUploadedFile(Throwable t) {
            FileUploadException fileUploadException = null;
            if (t instanceof FileUploadBase.IOFileUploadException || t instanceof FileUploadBase.FileUploadIOException) {
                Throwable causeThrowable = t.getCause();
                if (causeThrowable != null) {
                    t = causeThrowable;
                }
                if (t instanceof FileUploadException) {
                    fileUploadException = (FileUploadException)t;
                }
            } else if (t instanceof FileUploadException) {
                fileUploadException = (FileUploadException)t;
            }
            UploadedFileErrorImpl uploadedFile = fileUploadException instanceof FileUploadBase.SizeLimitExceededException ? new UploadedFileErrorImpl((Throwable)fileUploadException, UploadedFile.Status.REQUEST_SIZE_LIMIT_EXCEEDED) : (fileUploadException instanceof FileUploadBase.FileSizeLimitExceededException ? new UploadedFileErrorImpl((Throwable)fileUploadException, UploadedFile.Status.FILE_SIZE_LIMIT_EXCEEDED) : (t instanceof InvalidFileNameException ? new UploadedFileErrorImpl(t, UploadedFile.Status.FILE_INVALID_NAME_PATTERN) : (fileUploadException != null ? new UploadedFileErrorImpl((Throwable)fileUploadException) : new UploadedFileErrorImpl(t))));
            return uploadedFile;
        }
    }
}

