/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.factory.internal;

import com.liferay.faces.util.config.ConfiguredElement;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class FactoryExtensionFinderImpl
extends FactoryExtensionFinder {
    private static final Logger logger = LoggerFactory.getLogger(FactoryExtensionFinderImpl.class);
    private static final String FACTORY_EXTENSION_CACHE = FactoryExtensionFinderImpl.class.getName();

    @Override
    @Deprecated
    public Object getFactoryInstance(Class<?> factoryClass) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        return this.getFactoryInstance(externalContext, factoryClass);
    }

    @Override
    public Object getFactoryInstance(ExternalContext externalContext, Class<?> factoryClass) {
        Object factory = null;
        if (factoryClass != null) {
            Map<Class<?>, Object> factoryExtensionCache = this.getFactoryExtensionCache(externalContext);
            factory = factoryExtensionCache.get(factoryClass);
        }
        return factory;
    }

    @Override
    public void registerFactory(ConfiguredElement configuredFactoryExtension) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        this.registerFactory(externalContext, configuredFactoryExtension);
    }

    @Override
    public void registerFactory(ExternalContext externalContext, ConfiguredElement configuredFactoryExtension) {
        if (configuredFactoryExtension != null) {
            String factoryClassFQCN = configuredFactoryExtension.getValue();
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryExtensionClass = classLoader.loadClass(factoryClassFQCN);
                Class<?> baseFactoryExtensionClass = this.getBaseFactoryExtensionClass(factoryExtensionClass);
                Object existingFactoryInstance = this.getFactoryInstance(externalContext, baseFactoryExtensionClass);
                Object factoryInstance = this.newFactoryInstance(classLoader, factoryExtensionClass, baseFactoryExtensionClass, existingFactoryInstance);
                Map<Class<?>, Object> factoryExtensionCache = this.getFactoryExtensionCache(externalContext);
                factoryExtensionCache.put(baseFactoryExtensionClass, factoryInstance);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    @Override
    public void releaseFactories(ExternalContext externalContext) {
        Map applicationMap = externalContext.getApplicationMap();
        Map factoryExtensionCache = (Map)applicationMap.get(FACTORY_EXTENSION_CACHE);
        if (factoryExtensionCache != null) {
            factoryExtensionCache.clear();
            applicationMap.remove(FACTORY_EXTENSION_CACHE);
        }
    }

    private Class<?> getBaseFactoryExtensionClass(Class<?> factoryClass) {
        Class<?> baseFactoryExtensionClass = factoryClass;
        Class<?> factorySuperclass = factoryClass.getSuperclass();
        if (!Object.class.getName().equals(factorySuperclass.getName())) {
            baseFactoryExtensionClass = this.getBaseFactoryExtensionClass(factorySuperclass);
        }
        return baseFactoryExtensionClass;
    }

    private Map<Class<?>, Object> getFactoryExtensionCache(ExternalContext externalContext) {
        Map applicationMap = externalContext.getApplicationMap();
        HashMap factoryExtensionCache = (HashMap)applicationMap.get(FACTORY_EXTENSION_CACHE);
        if (factoryExtensionCache == null) {
            factoryExtensionCache = new HashMap();
            applicationMap.put(FACTORY_EXTENSION_CACHE, factoryExtensionCache);
        }
        return factoryExtensionCache;
    }

    private Object newFactoryInstance(ClassLoader classLoader, Class<?> factoryExtensionClass, Class<?> baseFactoryExtensionClass, Object wrappedFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object classInstance = null;
        if (classLoader != null && factoryExtensionClass != null) {
            Constructor<?>[] constructors;
            Constructor<?> wrapperConstructor = null;
            for (Constructor<?> constructor : constructors = factoryExtensionClass.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1 || !parameterTypes[0].getName().equals(baseFactoryExtensionClass.getName())) continue;
                wrapperConstructor = constructor;
            }
            if (wrapperConstructor == null) {
                logger.debug("Creating instance with zero-arg constructor since wrapperConstructor=null");
                try {
                    classInstance = factoryExtensionClass.newInstance();
                }
                catch (InstantiationException e) {
                    logger.error("Unable to create an instance of [{0}] with zero-arg constructor.", factoryExtensionClass.getName());
                    throw e;
                }
                catch (IllegalAccessException e) {
                    logger.error("Unable to create an instance of [{0}] with zero-arg constructor.", factoryExtensionClass.getName());
                    throw e;
                }
            }
            logger.debug("Creating instance with one-arg constructor since wrapperConstructor=[{0}]", wrapperConstructor);
            try {
                classInstance = wrapperConstructor.newInstance(wrappedFactory);
            }
            catch (InstantiationException e) {
                logger.error("Unable to create an instance of [{0}] with one-arg constructor.", factoryExtensionClass.getName());
                throw e;
            }
            catch (IllegalAccessException e) {
                logger.error("Unable to create an instance of [{0}] with one-arg constructor.", factoryExtensionClass.getName());
                throw e;
            }
            catch (IllegalArgumentException e) {
                logger.error("Unable to create an instance of [{0}] with one-arg constructor.", factoryExtensionClass.getName());
                throw e;
            }
            catch (InvocationTargetException e) {
                logger.error("Unable to create an instance of [{0}] with one-arg constructor.", factoryExtensionClass.getName());
                throw e;
            }
        }
        return classInstance;
    }
}

