/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.el.internal;

import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.el.ELResolverBase;
import com.liferay.faces.util.el.internal.I18nMap;
import com.liferay.faces.util.el.internal.ProductMap;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class UtilELResolver
extends ELResolverBase {
    private static final Logger logger = LoggerFactory.getLogger(UtilELResolver.class);
    private static final long serialVersionUID = 4993137243887595902L;
    private final I18nMap i18nMap = new I18nMap();

    public UtilELResolver() {
        super(UtilELResolver.newFeatureDescriptor("browserSniffer", BrowserSniffer.class), UtilELResolver.newFeatureDescriptor("i18n", String.class), UtilELResolver.newFeatureDescriptor("product", Product.class));
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        return true;
    }

    @Override
    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        if (elContext == null) {
            throw new NullPointerException("elContext may not be null");
        }
        if (property != null && property instanceof String) {
            String propertyAsString = (String)property;
            if (propertyAsString.equals("i18n")) {
                throw new PropertyNotWritableException(propertyAsString);
            }
            if (propertyAsString.equals("browserSniffer")) {
                throw new PropertyNotWritableException(propertyAsString);
            }
        }
    }

    @Override
    protected Object resolveProperty(ELContext elContext, Object base, String property) {
        return null;
    }

    @Override
    protected Object resolveVariable(ELContext elContext, String varName) {
        Object value = null;
        try {
            if (varName.equals("i18n")) {
                value = this.i18nMap;
            } else if (varName.equals("browserSniffer")) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ExternalContext externalContext = facesContext.getExternalContext();
                value = BrowserSnifferFactory.getBrowserSnifferInstance(externalContext);
            } else if (varName.equals("product")) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ExternalContext externalContext = facesContext.getExternalContext();
                ProductFactory productFactory = (ProductFactory)FactoryExtensionFinder.getFactory(externalContext, ProductFactory.class);
                value = new ProductMap(productFactory);
            }
        }
        catch (Exception e) {
            throw new ELException("Failed to resolve variable [" + varName + "]", (Throwable)e);
        }
        if (value == null) {
            logger.debug("Resolved variable [{0}] value=[null]", varName);
        } else {
            logger.debug("Unable to resolve variable [{0}] value=[{1}]", varName, value);
        }
        return value;
    }
}

