/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context.internal;

import com.liferay.faces.util.client.Script;
import com.liferay.faces.util.client.ScriptFactory;
import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.context.FacesContextHelper;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.helper.LongHelper;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;

public class FacesContextHelperImpl
implements FacesContextHelper,
Serializable {
    private static final long serialVersionUID = 5363868926989717581L;
    private static final String UNEXPECTED_ERROR_MSG_ID = "an-unexpected-error-occurred";
    private static final String SCRIPTS_KEY = FacesContextHelperImpl.class.getName() + "_SCRIPTS";
    private static final String SUCCESS_INFO_MSG_ID = "your-request-processed-successfully";

    @Override
    public void addComponentErrorMessage(String clientId, String messageId) {
        this.addComponentErrorMessage(FacesContext.getCurrentInstance(), clientId, messageId);
    }

    @Override
    public void addComponentErrorMessage(FacesContext facesContext, String clientId, String messageId) {
        this.addMessage(facesContext, clientId, FacesMessage.SEVERITY_ERROR, messageId);
    }

    @Override
    public void addComponentErrorMessage(String clientId, String messageId, Object ... arguments) {
        this.addComponentErrorMessage(FacesContext.getCurrentInstance(), clientId, messageId, arguments);
    }

    @Override
    public void addComponentErrorMessage(FacesContext facesContext, String clientId, String messageId, Object ... arguments) {
        this.addMessage(facesContext, clientId, FacesMessage.SEVERITY_ERROR, messageId, arguments);
    }

    @Override
    public void addComponentInfoMessage(String clientId, String messageId) {
        this.addComponentInfoMessage(FacesContext.getCurrentInstance(), clientId, messageId);
    }

    @Override
    public void addComponentInfoMessage(FacesContext facesContext, String clientId, String messageId) {
        this.addMessage(facesContext, clientId, FacesMessage.SEVERITY_INFO, messageId);
    }

    @Override
    public void addComponentInfoMessage(String clientId, String messageId, Object ... arguments) {
        this.addComponentInfoMessage(FacesContext.getCurrentInstance(), clientId, messageId, arguments);
    }

    @Override
    public void addComponentInfoMessage(FacesContext facesContext, String clientId, String messageId, Object ... arguments) {
        this.addMessage(facesContext, clientId, FacesMessage.SEVERITY_INFO, messageId, arguments);
    }

    @Override
    public void addGlobalErrorMessage(String messageId) {
        this.addGlobalErrorMessage(FacesContext.getCurrentInstance(), messageId);
    }

    @Override
    public void addGlobalErrorMessage(FacesContext facesContext, String messageId) {
        this.addComponentErrorMessage(facesContext, null, messageId);
    }

    @Override
    public void addGlobalErrorMessage(String messageId, Object ... arguments) {
        this.addGlobalErrorMessage(FacesContext.getCurrentInstance(), messageId, arguments);
    }

    @Override
    public void addGlobalErrorMessage(FacesContext facesContext, String messageId, Object ... arguments) {
        this.addComponentErrorMessage(facesContext, null, messageId, arguments);
    }

    @Override
    public void addGlobalInfoMessage(String messageId) {
        this.addGlobalInfoMessage(FacesContext.getCurrentInstance(), messageId);
    }

    @Override
    public void addGlobalInfoMessage(FacesContext facesContext, String messageId) {
        this.addComponentInfoMessage(facesContext, null, messageId);
    }

    @Override
    public void addGlobalInfoMessage(String messageId, Object ... arguments) {
        this.addGlobalInfoMessage(FacesContext.getCurrentInstance(), messageId, arguments);
    }

    @Override
    public void addGlobalInfoMessage(FacesContext facesContext, String messageId, Object ... arguments) {
        this.addComponentInfoMessage(facesContext, null, messageId, arguments);
    }

    @Override
    public void addGlobalSuccessInfoMessage() {
        this.addGlobalSuccessInfoMessage(FacesContext.getCurrentInstance());
    }

    @Override
    public void addGlobalSuccessInfoMessage(FacesContext facesContext) {
        this.addGlobalInfoMessage(facesContext, SUCCESS_INFO_MSG_ID);
    }

    @Override
    public void addGlobalUnexpectedErrorMessage() {
        this.addGlobalUnexpectedErrorMessage(FacesContext.getCurrentInstance());
    }

    @Override
    public void addGlobalUnexpectedErrorMessage(FacesContext facesContext) {
        this.addGlobalErrorMessage(facesContext, UNEXPECTED_ERROR_MSG_ID);
    }

    @Override
    public void addMessage(String clientId, FacesMessage.Severity severity, String messageId) {
        this.addMessage(FacesContext.getCurrentInstance(), clientId, severity, messageId);
    }

    @Override
    public void addMessage(FacesContext facesContext, String clientId, FacesMessage.Severity severity, String messageId) {
        Locale locale = this.getLocale(facesContext);
        I18n i18n = this.getI18n(facesContext);
        FacesMessage facesMessage = i18n.getFacesMessage(facesContext, locale, severity, messageId);
        facesContext.addMessage(clientId, facesMessage);
    }

    @Override
    public void addMessage(String clientId, FacesMessage.Severity severity, String messageId, Object ... arguments) {
        this.addMessage(FacesContext.getCurrentInstance(), clientId, severity, messageId, arguments);
    }

    @Override
    public void addMessage(FacesContext facesContext, String clientId, FacesMessage.Severity severity, String messageId, Object ... arguments) {
        Locale locale = this.getLocale(facesContext);
        I18n i18n = this.getI18n(facesContext);
        FacesMessage facesMessage = i18n.getFacesMessage(facesContext, locale, severity, messageId, arguments);
        facesContext.addMessage(clientId, facesMessage);
    }

    @Override
    public void addScript(Script script) {
        this.addScript(FacesContext.getCurrentInstance(), script);
    }

    @Override
    public void addScript(String scriptString) {
        this.addScript(FacesContext.getCurrentInstance(), scriptString);
    }

    @Override
    public void addScript(FacesContext facesContext, Script script) {
        this.getModifiableScriptsList(facesContext).add(script);
    }

    @Override
    public void addScript(FacesContext facesContext, String scriptString) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Script script = ScriptFactory.getScriptInstance(externalContext, scriptString);
        this.addScript(facesContext, script);
    }

    @Override
    public FacesContext getFacesContext() {
        return this.getFacesContext(FacesContext.getCurrentInstance());
    }

    public FacesContext getFacesContext(FacesContext facesContext) {
        return facesContext;
    }

    @Override
    public Locale getLocale() {
        return this.getLocale(FacesContext.getCurrentInstance());
    }

    @Override
    public Locale getLocale(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            Application application = facesContext.getApplication();
            locale = application.getDefaultLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    @Override
    public String getMessage(String messageId) {
        return this.getMessage(FacesContext.getCurrentInstance(), messageId);
    }

    @Override
    public String getMessage(FacesContext facesContext, String messageId) {
        return this.getMessage(facesContext, this.getLocale(facesContext), messageId);
    }

    @Override
    public String getMessage(String messageId, Object ... arguments) {
        return this.getMessage(FacesContext.getCurrentInstance(), messageId, arguments);
    }

    @Override
    public String getMessage(Locale locale, String messageId) {
        return this.getMessage(FacesContext.getCurrentInstance(), locale, messageId);
    }

    @Override
    public String getMessage(FacesContext facesContext, String messageId, Object ... arguments) {
        I18n i18n = this.getI18n(facesContext);
        return i18n.getMessage(facesContext, this.getLocale(facesContext), messageId, arguments);
    }

    @Override
    public String getMessage(FacesContext facesContext, Locale locale, String messageId) {
        I18n i18n = this.getI18n(facesContext);
        return i18n.getMessage(facesContext, locale, messageId);
    }

    @Override
    public String getMessage(Locale locale, String messageId, Object ... arguments) {
        return this.getMessage(FacesContext.getCurrentInstance(), locale, messageId, arguments);
    }

    @Override
    public String getMessage(FacesContext facesContext, Locale locale, String messageId, Object ... arguments) {
        I18n i18n = this.getI18n(facesContext);
        return i18n.getMessage(facesContext, locale, messageId, arguments);
    }

    @Override
    public String getNamespace() {
        return this.getNamespace(FacesContext.getCurrentInstance());
    }

    @Override
    public String getNamespace(FacesContext facesContext) {
        return facesContext.getExternalContext().encodeNamespace("");
    }

    @Override
    public UIForm getParentForm(UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent; parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    @Override
    public Object getRequestAttribute(String name) {
        return this.getRequestAttribute(FacesContext.getCurrentInstance(), name);
    }

    @Override
    public Object getRequestAttribute(FacesContext facesContext, String name) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        return httpServletRequest.getAttribute(name);
    }

    @Override
    public String getRequestContextPath() {
        return this.getRequestContextPath(FacesContext.getCurrentInstance());
    }

    @Override
    public String getRequestContextPath(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.getRequestContextPath();
    }

    @Override
    public String getRequestParameter(String name) {
        return this.getRequestParameter(FacesContext.getCurrentInstance(), name);
    }

    @Override
    public String getRequestParameter(FacesContext facesContext, String name) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        return (String)requestParameterMap.get(name);
    }

    @Override
    public boolean getRequestParameterAsBool(String name, boolean defaultValue) {
        return this.getRequestParameterAsBool(FacesContext.getCurrentInstance(), name, defaultValue);
    }

    @Override
    public boolean getRequestParameterAsBool(FacesContext facesContext, String name, boolean defaultValue) {
        return BooleanHelper.toBoolean(this.getRequestParameter(facesContext, name), defaultValue);
    }

    @Override
    public int getRequestParameterAsInt(String name, int defaultValue) {
        return this.getRequestParameterAsInt(FacesContext.getCurrentInstance(), name, defaultValue);
    }

    @Override
    public int getRequestParameterAsInt(FacesContext facesContext, String name, int defaultValue) {
        return IntegerHelper.toInteger(this.getRequestParameter(facesContext, name), defaultValue);
    }

    @Override
    public long getRequestParameterAsLong(String name, long defaultValue) {
        return this.getRequestParameterAsLong(FacesContext.getCurrentInstance(), name, defaultValue);
    }

    @Override
    public long getRequestParameterAsLong(FacesContext facesContext, String name, long defaultValue) {
        return LongHelper.toLong(this.getRequestParameter(facesContext, name), defaultValue);
    }

    @Override
    public String getRequestParameterFromMap(String name) {
        return this.getRequestParameterFromMap(FacesContext.getCurrentInstance(), name);
    }

    @Override
    public String getRequestParameterFromMap(FacesContext facesContext, String name) {
        ExternalContext externalContext = facesContext.getExternalContext();
        return (String)externalContext.getRequestParameterMap().get(name);
    }

    @Override
    public Map<String, String> getRequestParameterMap() {
        return this.getRequestParameterMap(FacesContext.getCurrentInstance());
    }

    @Override
    public Map<String, String> getRequestParameterMap(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.getRequestParameterMap();
    }

    @Override
    public String getRequestQueryString() {
        return this.getRequestQueryString(FacesContext.getCurrentInstance());
    }

    @Override
    public String getRequestQueryString(FacesContext facesContext) {
        return (String)this.getRequestAttribute(facesContext, "javax.servlet.forward.query_string");
    }

    @Override
    public String getRequestQueryStringParameter(String name) {
        return this.getRequestQueryStringParameter(FacesContext.getCurrentInstance(), name);
    }

    @Override
    public String getRequestQueryStringParameter(FacesContext facesContext, String name) {
        String value = null;
        String queryString = this.getRequestQueryString(facesContext);
        if (queryString != null) {
            String[] queryStringTokens = queryString.split("&");
            boolean found = false;
            for (int i = 0; !found && i < queryStringTokens.length; ++i) {
                String nameValuePair = queryStringTokens[i];
                String[] nameValuePairArray = nameValuePair.split("=");
                found = nameValuePairArray[0].equals(name);
                if (!found || nameValuePairArray.length <= 1) continue;
                value = nameValuePairArray[1];
            }
        }
        return value;
    }

    @Override
    public List<Script> getScripts() {
        return this.getScripts(FacesContext.getCurrentInstance());
    }

    @Override
    public List<Script> getScripts(FacesContext facesContext) {
        return Collections.unmodifiableList(this.getModifiableScriptsList(facesContext));
    }

    @Override
    public Object getSession(boolean create) {
        return this.getSession(FacesContext.getCurrentInstance(), create);
    }

    @Override
    public Object getSession(FacesContext facesContext, boolean create) {
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.getSession(create);
    }

    @Override
    public Object getSessionAttribute(String name) {
        return this.getSessionAttribute(FacesContext.getCurrentInstance(), name);
    }

    @Override
    public Object getSessionAttribute(FacesContext facesContext, String name) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        return sessionMap.get(name);
    }

    @Override
    public UIComponent matchComponentInHierarchy(UIComponent parent, String partialClientId) {
        return this.matchComponentInHierarchy(FacesContext.getCurrentInstance(), parent, partialClientId);
    }

    @Override
    public UIComponent matchComponentInHierarchy(FacesContext facesContext, UIComponent parent, String partialClientId) {
        return ComponentUtil.matchComponentInHierarchy(facesContext, parent, partialClientId);
    }

    @Override
    public UIComponent matchComponentInViewRoot(String partialClientId) {
        return this.matchComponentInViewRoot(FacesContext.getCurrentInstance(), partialClientId);
    }

    @Override
    public UIComponent matchComponentInViewRoot(FacesContext facesContext, String partialClientId) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        return this.matchComponentInHierarchy(facesContext, (UIComponent)viewRoot, partialClientId);
    }

    @Override
    public void navigate(String fromAction, String outcome) {
        this.navigate(FacesContext.getCurrentInstance(), fromAction, outcome);
    }

    @Override
    public void navigate(FacesContext facesContext, String fromAction, String outcome) {
        Application application = facesContext.getApplication();
        NavigationHandler navigationHandler = application.getNavigationHandler();
        navigationHandler.handleNavigation(facesContext, fromAction, outcome);
    }

    @Override
    public void navigateTo(String outcome) {
        this.navigateTo(FacesContext.getCurrentInstance(), outcome);
    }

    @Override
    public void navigateTo(FacesContext facesContext, String outcome) {
        this.navigate(facesContext, null, outcome);
    }

    @Override
    public void recreateComponentTree() {
        this.recreateComponentTree(FacesContext.getCurrentInstance());
    }

    @Override
    public void recreateComponentTree(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot oldViewRoot = facesContext.getViewRoot();
        UIViewRoot viewRoot = viewHandler.createView(facesContext, oldViewRoot.getViewId());
        facesContext.setViewRoot(viewRoot);
        facesContext.renderResponse();
    }

    @Override
    public void registerPhaseListener(PhaseListener phaseListener) throws IllegalStateException {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator lifecycleIds = lifecycleFactory.getLifecycleIds();
        while (lifecycleIds.hasNext()) {
            String lifecycleId = (String)lifecycleIds.next();
            lifecycleFactory.getLifecycle(lifecycleId).addPhaseListener(phaseListener);
        }
    }

    @Override
    public void removeChildrenFromComponentTree(String clientId) {
        this.removeChildrenFromComponentTree(FacesContext.getCurrentInstance(), clientId);
    }

    @Override
    public void removeChildrenFromComponentTree(FacesContext facesContext, String clientId) {
        UIComponent uiComponent = facesContext.getViewRoot().findComponent(clientId);
        if (uiComponent != null) {
            uiComponent.getChildren().clear();
            uiComponent.getFacets().clear();
        }
    }

    @Override
    public void removeMessages(String clientId) {
        this.removeMessages(FacesContext.getCurrentInstance(), clientId);
    }

    @Override
    public void removeMessages(FacesContext facesContext, String clientId) {
        Iterator facesMessages = facesContext.getMessages(clientId);
        while (facesMessages.hasNext()) {
            facesMessages.next();
            facesMessages.remove();
        }
    }

    @Override
    public void removeMessagesForImmediateComponents() {
        this.removeMessagesForImmediateComponents(FacesContext.getCurrentInstance());
    }

    @Override
    public void removeMessagesForImmediateComponents(FacesContext facesContext) {
        this.removeMessagesForImmediateComponents(facesContext, (UIComponent)facesContext.getViewRoot());
    }

    @Override
    public void removeMessagesForImmediateComponents(UIComponent uiComponent) {
        this.removeMessagesForImmediateComponents(FacesContext.getCurrentInstance(), uiComponent);
    }

    @Override
    public void removeMessagesForImmediateComponents(FacesContext facesContext, UIComponent uiComponent) {
        EditableValueHolder editableValueHolder;
        if (uiComponent instanceof ActionSource) {
            ActionSource actionSource = (ActionSource)uiComponent;
            if (actionSource.isImmediate()) {
                this.removeMessages(facesContext, uiComponent.getClientId(facesContext));
            }
        } else if (uiComponent instanceof EditableValueHolder && (editableValueHolder = (EditableValueHolder)uiComponent).isImmediate()) {
            this.removeMessages(facesContext, uiComponent.getClientId(facesContext));
        }
        List childComponents = uiComponent.getChildren();
        for (UIComponent childComponent : childComponents) {
            this.removeMessagesForImmediateComponents(facesContext, childComponent);
        }
    }

    @Override
    public void removeParentFormFromComponentTree(UIComponent uiComponent) {
        UIForm form = this.getParentForm(uiComponent);
        if (form != null) {
            form.getChildren().clear();
            form.getFacets().clear();
        }
    }

    @Override
    public void resetView() {
        this.resetView(FacesContext.getCurrentInstance());
    }

    @Override
    public void resetView(FacesContext facesContext) {
        this.resetView(facesContext, true);
    }

    @Override
    public void resetView(boolean renderResponse) {
        this.resetView(FacesContext.getCurrentInstance(), renderResponse);
    }

    @Override
    public void resetView(FacesContext facesContext, boolean renderResponse) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        UIViewRoot emptyView = viewHandler.createView(facesContext, viewRoot.getViewId());
        facesContext.setViewRoot(emptyView);
        if (renderResponse) {
            facesContext.renderResponse();
        }
    }

    @Override
    public Object resolveExpression(String elExpression) {
        return this.resolveExpression(FacesContext.getCurrentInstance(), elExpression);
    }

    @Override
    public Object resolveExpression(FacesContext facesContext, String elExpression) {
        Application application = facesContext.getApplication();
        ELResolver elResolver = application.getELResolver();
        ELContext elContext = facesContext.getELContext();
        return elResolver.getValue(elContext, null, (Object)elExpression);
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        this.setRequestAttribute(FacesContext.getCurrentInstance(), name, value);
    }

    @Override
    public void setRequestAttribute(FacesContext facesContext, String name, Object value) {
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        httpServletRequest.setAttribute(name, value);
    }

    @Override
    public void setSessionAttribute(String name, Object value) {
        this.setSessionAttribute(FacesContext.getCurrentInstance(), name, value);
    }

    @Override
    public void setSessionAttribute(FacesContext facesContext, String name, Object value) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        sessionMap.put(name, value);
    }

    private I18n getI18n(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        return I18nFactory.getI18nInstance(externalContext);
    }

    private List<Script> getModifiableScriptsList(FacesContext facesContext) {
        Map attributes = facesContext.getAttributes();
        ArrayList scripts = (ArrayList)attributes.get(SCRIPTS_KEY);
        if (scripts == null) {
            scripts = new ArrayList();
            attributes.put(SCRIPTS_KEY, scripts);
        }
        return scripts;
    }
}

