/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.ConfiguredServlet;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.FacesConfig;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.internal.ConfiguredServletMappingImpl;
import com.liferay.faces.util.config.internal.FacesConfigDescriptor;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorParser;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorParserImpl;
import com.liferay.faces.util.config.internal.FacesConfigImpl;
import com.liferay.faces.util.config.internal.FacesConfigParser;
import com.liferay.faces.util.config.internal.FacesConfigParserImpl;
import com.liferay.faces.util.config.internal.FacesConfigScanner;
import com.liferay.faces.util.config.internal.OrderingUtil;
import com.liferay.faces.util.config.internal.ResourceReader;
import com.liferay.faces.util.internal.CloseableUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.internal.ProductMojarraImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.faces.webapp.FacesServlet;
import javax.xml.parsers.SAXParser;

public class FacesConfigScannerImpl
implements FacesConfigScanner {
    private static final Logger logger = LoggerFactory.getLogger(FacesConfigScannerImpl.class);
    private static final String FACES_CONFIG_META_INF_PATH = "META-INF/faces-config.xml";
    private static final String FACES_CONFIG_WEB_INF_PATH = "/WEB-INF/faces-config.xml";
    private static final String FACES_SERVLET = "Faces Servlet";
    private static final String FACES_SERVLET_FQCN = FacesServlet.class.getName();
    private static final String MOJARRA_CONFIG_PATH = "com/sun/faces/jsf-ri-runtime.xml";
    private ClassLoader classLoader;
    private boolean resolveEntities;
    private ResourceReader resourceReader;
    private SAXParser saxParser;
    private WebConfig webConfig;

    public FacesConfigScannerImpl(ClassLoader classLoader, ResourceReader resourceReader, SAXParser saxParser, boolean resolveEntities, WebConfig webConfig) {
        this.classLoader = classLoader;
        this.saxParser = saxParser;
        this.resourceReader = resourceReader;
        this.resolveEntities = resolveEntities;
        this.webConfig = webConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FacesConfig scan() throws IOException {
        InputStream inputStream;
        FacesConfig facesConfig;
        block24: {
            String defaultSuffixParam;
            List<ConfiguredServletMapping> configuredServletMappings;
            String configuredFacesServletName = FACES_SERVLET;
            ArrayList<ConfiguredServletMapping> facesServletMappings = new ArrayList<ConfiguredServletMapping>();
            List<ConfiguredServlet> configuredServlets = this.webConfig.getConfiguredServlets();
            if (configuredServlets != null) {
                for (ConfiguredServlet configuredServlet : configuredServlets) {
                    if (!FACES_SERVLET_FQCN.equals(configuredServlet.getServletClass())) continue;
                    configuredFacesServletName = configuredServlet.getServletName();
                    break;
                }
            }
            if ((configuredServletMappings = this.webConfig.getConfiguredServletMappings()) != null) {
                for (ConfiguredServletMapping configuredServletMapping : configuredServletMappings) {
                    if (!configuredFacesServletName.equals(configuredServletMapping.getServletName())) continue;
                    facesServletMappings.add(configuredServletMapping);
                }
            }
            if ((defaultSuffixParam = this.webConfig.getConfiguredContextParams().get("javax.faces.DEFAULT_SUFFIX")) == null) {
                defaultSuffixParam = ".xhtml .view.xml .jsp";
            }
            List<String> configuredSuffixes = Arrays.asList(defaultSuffixParam.split(" "));
            for (String configuredSuffix : configuredSuffixes) {
                boolean found = false;
                for (ConfiguredServletMapping explicitFacesServletMapping : facesServletMappings) {
                    if (!explicitFacesServletMapping.isExtensionMapped() || !explicitFacesServletMapping.getExtension().equals(configuredSuffix)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String urlPattern = "*" + configuredSuffix;
                ConfiguredServletMappingImpl implicitFacesServletMapping = new ConfiguredServletMappingImpl(FACES_SERVLET, urlPattern, true);
                facesServletMappings.add(implicitFacesServletMapping);
                logger.debug("Added implicit extension-mapped servlet-mapping for urlPattern=[{0}]", urlPattern);
            }
            facesConfig = new FacesConfigImpl(facesServletMappings, configuredSuffixes);
            inputStream = null;
            try {
                FacesConfigDescriptorParser facesConfigDescriptorParser = this.newFacesConfigDescriptorParser();
                inputStream = this.resourceReader.getResourceAsStream(FACES_CONFIG_WEB_INF_PATH);
                FacesConfigDescriptor webInfFacesConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, FACES_CONFIG_WEB_INF_PATH);
                inputStream.close();
                Enumeration<URL> mojarraConfigURLs = this.classLoader.getResources(MOJARRA_CONFIG_PATH);
                ProductMojarraImpl MOJARRA = new ProductMojarraImpl();
                if (MOJARRA.isDetected() && (mojarraConfigURLs == null || !mojarraConfigURLs.hasMoreElements())) {
                    logger.warn("{0} not found.", MOJARRA_CONFIG_PATH);
                }
                if (mojarraConfigURLs != null) {
                    boolean processedMojarraConfig = false;
                    while (mojarraConfigURLs.hasMoreElements()) {
                        URL mojarraConfigURL = mojarraConfigURLs.nextElement();
                        if (processedMojarraConfig) {
                            logger.debug("Skipping Mojarra config: [{0}]", mojarraConfigURL);
                            continue;
                        }
                        logger.debug("Processing Mojarra config: [{0}]", mojarraConfigURL);
                        FacesConfigParserImpl mojarraConfigParser = new FacesConfigParserImpl(this.saxParser, this.resolveEntities);
                        inputStream = mojarraConfigURL.openStream();
                        try {
                            facesConfig = mojarraConfigParser.parse(inputStream, facesConfig);
                        }
                        catch (IOException e) {
                            logger.error(e);
                        }
                        inputStream.close();
                        processedMojarraConfig = true;
                    }
                }
                FacesConfigParser facesConfigParser = this.newFacesConfigParser();
                Enumeration<URL> facesConfigURLs = this.classLoader.getResources(FACES_CONFIG_META_INF_PATH);
                ArrayList<FacesConfigDescriptor> facesConfigDescriptors = new ArrayList<FacesConfigDescriptor>();
                if (facesConfigURLs != null) {
                    while (facesConfigURLs.hasMoreElements()) {
                        URL facesConfigURL = facesConfigURLs.nextElement();
                        logger.debug("Pre-processing faces-config: [{0}]", facesConfigURL);
                        inputStream = facesConfigURL.openStream();
                        FacesConfigDescriptor facesConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, facesConfigURL);
                        facesConfigDescriptors.add(facesConfigDescriptor);
                        inputStream.close();
                    }
                    List<FacesConfigDescriptor> orderedConfigs = this.getOrderedConfigs(facesConfigDescriptors, webInfFacesConfigDescriptor);
                    for (FacesConfigDescriptor config : orderedConfigs) {
                        String urlString = config.getURL();
                        URL url = new URL(urlString);
                        logger.debug("Post-processing faces-config: [{0}]", url);
                        inputStream = url.openStream();
                        try {
                            facesConfig = facesConfigParser.parse(inputStream, facesConfig);
                        }
                        catch (IOException e) {
                            logger.error(e);
                        }
                        inputStream.close();
                        try {
                            this.saxParser.reset();
                        }
                        catch (Exception e) {
                            logger.error(e);
                        }
                    }
                }
                if ((inputStream = this.resourceReader.getResourceAsStream(FACES_CONFIG_WEB_INF_PATH)) == null) break block24;
                logger.debug("Processing faces-config: [{0}]", FACES_CONFIG_WEB_INF_PATH);
                facesConfig = facesConfigParser.parse(inputStream, facesConfig);
                inputStream.close();
            }
            catch (Exception e) {
                try {
                    logger.error(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    CloseableUtil.close(inputStream);
                    throw throwable;
                }
                CloseableUtil.close(inputStream);
            }
        }
        CloseableUtil.close(inputStream);
        return facesConfig;
    }

    protected List<FacesConfigDescriptor> getOrderedConfigs(List<FacesConfigDescriptor> facesConfigDescriptors, FacesConfigDescriptor webInfFacesConfig) throws Exception {
        if (facesConfigDescriptors.size() > 1) {
            List<String> absoluteOrdering = webInfFacesConfig.getAbsoluteOrdering();
            if (absoluteOrdering == null) {
                logger.debug("Ordering faces-config descriptors");
                facesConfigDescriptors = OrderingUtil.getOrder(facesConfigDescriptors);
            } else {
                logger.debug("Ordering faces-config descriptors: absoluteOrdering=[{0}]", absoluteOrdering);
                facesConfigDescriptors = OrderingUtil.getOrder(facesConfigDescriptors, absoluteOrdering);
            }
        }
        return facesConfigDescriptors;
    }

    protected SAXParser getSAXParser() {
        return this.saxParser;
    }

    protected FacesConfigDescriptorParser newFacesConfigDescriptorParser() {
        return new FacesConfigDescriptorParserImpl(this.saxParser, this.resolveEntities);
    }

    protected FacesConfigParser newFacesConfigParser() {
        return new FacesConfigParserImpl(this.saxParser, this.resolveEntities);
    }
}

