/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.application;

import com.liferay.faces.util.application.ResourceUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.faces.application.ResourceWrapper;

public abstract class FilteredResourceBase
extends ResourceWrapper {
    private static final Logger logger = LoggerFactory.getLogger(FilteredResourceBase.class);

    public String getContentType() {
        return this.getWrapped().getContentType();
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = super.getInputStream();
        if (inputStream != null) {
            String contentType = this.getContentType();
            if (contentType == null || !contentType.startsWith("audio") && !contentType.startsWith("image") && !contentType.startsWith("model") && !contentType.startsWith("video")) {
                Map responseHeaders;
                String encoding;
                if (contentType == null || !contentType.startsWith("text")) {
                    logger.debug("Content-Type is \"{0}\" which may not be a filterable text content type.", contentType);
                }
                if ((encoding = (String)(responseHeaders = this.getResponseHeaders()).get("Content-Encoding")) == null) {
                    encoding = this.getEncoding();
                }
                String inputStreamAsString = ResourceUtil.toString(inputStream, encoding, this.getBufferSize());
                inputStreamAsString = this.filter(inputStreamAsString);
                inputStream = ResourceUtil.toInputStream(inputStreamAsString, encoding);
            } else {
                logger.warn("Resource not filtered because it's Content-Type=[{0}] which is not a text content type.", contentType);
            }
        }
        return inputStream;
    }

    public String getLibraryName() {
        return this.getWrapped().getLibraryName();
    }

    public String getResourceName() {
        return this.getWrapped().getResourceName();
    }

    public void setContentType(String contentType) {
        this.getWrapped().setContentType(contentType);
    }

    public void setLibraryName(String libraryName) {
        this.getWrapped().setLibraryName(libraryName);
    }

    public void setResourceName(String resourceName) {
        this.getWrapped().setResourceName(resourceName);
    }

    public String toString() {
        return this.getWrapped().toString();
    }

    protected abstract String filter(String var1);

    protected int getBufferSize() {
        return 1024;
    }

    protected String getEncoding() {
        return "UTF-8";
    }
}

