/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.util.internal;

import com.liferay.faces.bridge.context.map.internal.AbstractImmutablePropertyMap;
import com.liferay.faces.bridge.util.internal.DefaultViewIdMapEntry;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.portlet.PortletConfig;

public class DefaultViewIdMap
extends AbstractImmutablePropertyMap<String> {
    private static final String DEFAULT_VIEWID_PREFIX = "javax.portlet.faces.defaultViewId.";
    private final PortletConfig portletConfig;

    public DefaultViewIdMap(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    protected AbstractPropertyMapEntry<String> createPropertyMapEntry(String name) {
        return new DefaultViewIdMapEntry(this.portletConfig, name);
    }

    @Override
    protected Enumeration<String> getImmutablePropertyNames() {
        Enumeration immutablePropertyNames = this.portletConfig.getInitParameterNames();
        ArrayList<String> immutablePropertyNamesList = new ArrayList<String>();
        while (immutablePropertyNames.hasMoreElements()) {
            String immutablePropertyName = (String)immutablePropertyNames.nextElement();
            if (!immutablePropertyName.startsWith(DEFAULT_VIEWID_PREFIX)) continue;
            immutablePropertyNamesList.add(immutablePropertyName);
        }
        return Collections.enumeration(immutablePropertyNamesList);
    }

    protected String getProperty(String defaultViewIdInitParamName) {
        Object defaultViewId;
        if (defaultViewIdInitParamName != null && !((String)defaultViewIdInitParamName).startsWith(DEFAULT_VIEWID_PREFIX)) {
            defaultViewIdInitParamName = DEFAULT_VIEWID_PREFIX + (String)defaultViewIdInitParamName;
        }
        if ((defaultViewId = this.portletConfig.getInitParameter((String)defaultViewIdInitParamName)) != null && !((String)defaultViewId).startsWith("/")) {
            defaultViewId = "/" + (String)defaultViewId;
        }
        return defaultViewId;
    }
}

