/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.servlet;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.portlet.annotations.PortletRequestScoped;
import javax.portlet.faces.annotation.BridgeRequestScoped;

public class BridgeRequestScopeExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeExtension.class);
    private static final Annotation _bridgeRequestScoped = new BridgeRequestScoped(){

        public Class<? extends Annotation> annotationType() {
            return BridgeRequestScoped.class;
        }
    };

    private <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        HashSet<Annotation> annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
        if (annotatedType.isAnnotationPresent(RequestScoped.class)) {
            annotations.remove(annotatedType.getAnnotation(RequestScoped.class));
            annotations.add(_bridgeRequestScoped);
            logger.info("Automatically changed @RequestScoped to @BridgeRequestScoped for [{0}].", new Object[]{annotatedType.getJavaClass()});
        } else if (annotatedType.isAnnotationPresent(PortletRequestScoped.class)) {
            annotations.remove(annotatedType.getAnnotation(PortletRequestScoped.class));
            annotations.add(_bridgeRequestScoped);
            logger.info("Automatically changed @PortletRequestScoped to @BridgeRequestScoped for [{0}].", new Object[]{annotatedType.getJavaClass()});
        }
        if (!annotations.equals(annotatedType.getAnnotations())) {
            processAnnotatedType.setAnnotatedType(new ModifiedAnnotatedType(annotatedType, annotations, annotatedType.getTypeClosure()));
        }
    }

    private static final class ModifiedAnnotatedType<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> annotatedType;
        private final Set<Annotation> annotations;
        private final Set<Type> types;

        public ModifiedAnnotatedType(AnnotatedType<X> annotatedType, Set<Annotation> annotations, Set<Type> types) {
            this.annotatedType = annotatedType;
            this.annotations = Collections.unmodifiableSet(annotations);
            this.types = Collections.unmodifiableSet(types);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation annotation : this.annotations) {
                Class<? extends Annotation> curAnnotationType = annotation.annotationType();
                if (!curAnnotationType.equals(annotationType)) continue;
                return (T)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Type getBaseType() {
            return this.annotatedType.getBaseType();
        }

        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.annotatedType.getConstructors();
        }

        public Set<AnnotatedField<? super X>> getFields() {
            return this.annotatedType.getFields();
        }

        public Class<X> getJavaClass() {
            return this.annotatedType.getJavaClass();
        }

        public Set<AnnotatedMethod<? super X>> getMethods() {
            return this.annotatedType.getMethods();
        }

        public Set<Type> getTypeClosure() {
            return this.types;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            for (Annotation annotation : this.annotations) {
                Class<? extends Annotation> curAnnotationType = annotation.annotationType();
                if (!curAnnotationType.equals(annotationType)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class BridgeRequestScopedAnnotation
    implements Annotation {
        private BridgeRequestScopedAnnotation() {
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return BridgeRequestScoped.class;
        }
    }
}

