/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.internal.BaseURLBridgeURIAdapterImpl;
import com.liferay.faces.bridge.internal.BridgeURLBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.FacesURLEncoder;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.PortletConfig;
import javax.portlet.faces.BridgeConfig;

public class BridgeURLPartialActionImpl
extends BridgeURLBase {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURLPartialActionImpl.class);

    public BridgeURLPartialActionImpl(String uri, String contextPath, String namespace, String encoding, FacesURLEncoder facesURLEncoder, String currentViewId, boolean clientWindowEnabled, String clientWindowId, Map<String, String> clientWindowParameters, PortletConfig portletConfig, BridgeConfig bridgeConfig) throws URISyntaxException, UnsupportedEncodingException {
        super(uri, contextPath, namespace, encoding, facesURLEncoder, currentViewId, portletConfig, bridgeConfig);
        if (clientWindowEnabled && clientWindowId != null && uri != null && !uri.contains("jfwid")) {
            this.bridgeURI.setParameter("jfwid", clientWindowId);
            if (clientWindowParameters != null) {
                this.bridgeURI.addParameters(clientWindowParameters);
            }
        }
        this.bridgeURI.setParameter("_jsfBridgeAjax", "true");
    }

    @Override
    public BaseURL toBaseURL(FacesContext facesContext) throws MalformedURLException {
        BaseURLBridgeURIAdapterImpl baseURL = null;
        String uri = this.bridgeURI.toString();
        if (uri != null) {
            if (uri.startsWith("http")) {
                baseURL = new BaseURLBridgeURIAdapterImpl(this.bridgeURI);
                logger.debug("URL starts with http so assuming that it has already been encoded: url=[{0}]", new Object[]{uri});
            } else {
                baseURL = this.createResourceURL(facesContext, this.bridgeURI.getParameterMap());
            }
        } else {
            logger.warn("Unable to encode PartialActionURL for url=[null]");
        }
        return baseURL;
    }

    @Override
    protected String getViewIdParameterName() {
        return this.viewIdResourceParameterName;
    }
}

