/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.internal.BridgePhaseRenderCompatImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.faces.BridgeConfig;
import javax.portlet.faces.BridgeException;

public class BridgePhaseRenderImpl
extends BridgePhaseRenderCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseRenderImpl.class);

    public BridgePhaseRenderImpl(RenderRequest renderRequest, RenderResponse renderResponse, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        super(renderRequest, renderResponse, portletConfig, bridgeConfig);
    }

    @Override
    public void execute() throws BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(RenderRequest, RenderResponse) portletName=[{0}] portletMode=[{1}]", new Object[]{this.portletName, this.renderRequest.getPortletMode()});
        Object renderPartAttribute = this.renderRequest.getAttribute("javax.portlet.render_part");
        if (renderPartAttribute != null && renderPartAttribute.equals("RENDER_HEADERS")) {
            this.doFacesHeaders(this.renderRequest, this.renderResponse);
        } else {
            try {
                this.execute(null);
            }
            catch (BridgeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new BridgeException(t);
            }
            finally {
                this.cleanup((PortletRequest)this.renderRequest);
            }
            logger.debug("----------------------------------------------------------------------");
        }
    }

    @Override
    protected void cleanup(PortletRequest portletRequest) {
        if (!this.bridgeRequestScopeActionEnabled) {
            this.bridgeRequestScopeCache.removeValue((Object)this.bridgeRequestScope.getId());
        }
        super.cleanup(portletRequest);
    }

    protected void doFacesHeaders(RenderRequest renderRequest, RenderResponse renderResponse) {
        logger.trace("doFacesHeaders(RenderRequest, RenderResponse) this=[{0}], renderRequest=[{1}], renderResponse=[{2}]", new Object[]{this, renderRequest, renderResponse});
    }
}

