/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.el.internal;

import com.liferay.faces.bridge.context.internal.LegacyBridgeContext;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.el.internal.ELResolverCompatImpl;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.preference.internal.MutablePreferenceMap;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeConfig;
import javax.portlet.faces.BridgeFactoryFinder;
import javax.portlet.faces.BridgeUtil;
import javax.servlet.jsp.JspContext;

public class ELResolverImpl
extends ELResolverCompatImpl {
    private static final String ACTION_REQUEST = "actionRequest";
    private static final String ACTION_RESPONSE = "actionResponse";
    private static final String BRIDGE_CONFIG = "bridgeConfig";
    private static final String BRIDGE_CONTEXT = "bridgeContext";
    private static final String EVENT_REQUEST = "eventRequest";
    private static final String EVENT_RESPONSE = "eventResponse";
    private static final String FLASH = "bridgeFlash";
    private static final String HTTP_SESSION_SCOPE = "httpSessionScope";
    private static final String MUTABLE_PORTLET_PREFERENCES_VALUES = "mutablePortletPreferencesValues";
    private static final String PORTLET_CONFIG = "portletConfig";
    private static final String PORTLET_SESSION = "portletSession";
    private static final String PORTLET_SESSION_SCOPE = "portletSessionScope";
    private static final String PORTLET_PREFERENCES = "portletPreferences";
    private static final String PORTLET_PREFERENCES_VALUES = "portletPreferencesValues";
    private static final String RENDER_REQUEST = "renderRequest";
    private static final String RENDER_RESPONSE = "renderResponse";
    private static final String RESOURCE_REQUEST = "resourceRequest";
    private static final String RESOURCE_RESPONSE = "resourceResponse";
    private static final List<FeatureDescriptor> FEATURE_DESCRIPTORS;
    private static final Set<String> FACES_CONTEXT_VAR_NAMES;
    private static final Set<String> JSP_CONTEXT_VAR_NAMES;

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        Class<String> commonPropertyType = null;
        if (base == null) {
            commonPropertyType = String.class;
        }
        return commonPropertyType;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        if (base != null) {
            return null;
        }
        return FEATURE_DESCRIPTORS.iterator();
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException("elContext may not be null");
        }
        if (base == null && property == null) {
            throw new PropertyNotFoundException("Property name is null.");
        }
        if (base == null && this.canHandleVar(property)) {
            elContext.setPropertyResolved(true);
        }
        return null;
    }

    public Object getValue(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException();
        }
        if (base == null && property == null) {
            throw new PropertyNotFoundException("Property name is null.");
        }
        Object value = null;
        if (base == null) {
            value = elContext.getContext(JspContext.class) != null ? this.resolveJspContext(elContext, base, property) : this.resolveFacesContext(elContext, base, property);
        }
        return value;
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        if (base == null && property == null) {
            throw new PropertyNotFoundException("Property name is null.");
        }
        if (base == null && this.canHandleVar(property)) {
            elContext.setPropertyResolved(true);
        }
        return true;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        if (elContext == null) {
            throw new NullPointerException("elContext may not be null");
        }
        if (base == null && property == null) {
            throw new PropertyNotFoundException("Property name is null.");
        }
        if (base == null && this.canHandleVar(property)) {
            throw new PropertyNotWritableException(property.toString());
        }
    }

    @Override
    protected PortletRequest getPortletRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Object request = externalContext.getRequest();
        if (request instanceof PortletRequest) {
            return (PortletRequest)request;
        }
        return null;
    }

    @Override
    protected PortletResponse getPortletResponse(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Object response = externalContext.getResponse();
        if (response instanceof PortletResponse) {
            return (PortletResponse)response;
        }
        return null;
    }

    @Override
    protected boolean isFacesContextVar(String varName) {
        return FACES_CONTEXT_VAR_NAMES.contains(varName) || super.isFacesContextVar(varName);
    }

    protected Object resolveFacesContext(ELContext elContext, Object base, Object property) {
        Object value = null;
        if (base == null) {
            String varName;
            if (property instanceof String && this.isFacesContextVar(varName = (String)property)) {
                value = this.resolveVariable(elContext, varName);
            }
        } else if (property instanceof String) {
            String propertyName = (String)property;
            value = this.resolveProperty(elContext, base, propertyName);
        }
        if (value != null) {
            elContext.setPropertyResolved(true);
        }
        return value;
    }

    protected Object resolveJspContext(ELContext elContext, Object base, Object property) {
        Object value = null;
        if (base == null) {
            String varName;
            if (property instanceof String && JSP_CONTEXT_VAR_NAMES.contains(varName = (String)property)) {
                value = this.resolveVariable(elContext, varName);
            }
        } else if (property instanceof String) {
            String propertyName = (String)property;
            value = this.resolveProperty(elContext, base, propertyName);
        }
        if (value != null) {
            elContext.setPropertyResolved(true);
        }
        return value;
    }

    protected Object resolveProperty(ELContext elContext, Object base, String property) {
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object resolveVariable(ELContext elContext, String varName) {
        void var3_27;
        Object var3_3 = null;
        if (varName == null) return var3_27;
        if (varName.equals(ACTION_REQUEST)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.ACTION_PHASE) throw new ELException("Unable to get actionRequest during " + portletPhase);
            PortletRequest portletRequest = this.getPortletRequest(facesContext);
            return var3_27;
        } else if (varName.equals(ACTION_RESPONSE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.ACTION_PHASE) throw new ELException("Unable to get actionResponse during " + portletPhase);
            PortletResponse portletResponse = this.getPortletResponse(facesContext);
            return var3_27;
        } else if (varName.equals(BRIDGE_CONFIG) || varName.equals(BRIDGE_CONTEXT) || varName.equals(PORTLET_CONFIG)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            BridgeConfig bridgeConfig = RequestMapUtil.getBridgeConfig(portletRequest);
            if (varName.equals(BRIDGE_CONFIG)) {
                BridgeConfig bridgeConfig2 = bridgeConfig;
                return var3_27;
            } else if (varName.equals(PORTLET_CONFIG)) {
                PortletConfig portletConfig = this.unwrapPortletConfig(RequestMapUtil.getPortletConfig(portletRequest));
                return var3_27;
            } else {
                LegacyBridgeContext legacyBridgeContext = new LegacyBridgeContext(bridgeConfig);
            }
            return var3_27;
        } else if (varName.equals(EVENT_REQUEST)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.EVENT_PHASE) throw new ELException("Unable to get eventRequest during " + portletPhase);
            PortletRequest portletRequest = this.getPortletRequest(facesContext);
            return var3_27;
        } else if (varName.equals(EVENT_RESPONSE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.EVENT_PHASE) throw new ELException("Unable to get eventResponse during " + portletPhase);
            PortletResponse portletResponse = this.getPortletResponse(facesContext);
            return var3_27;
        } else if (varName.equals(FLASH)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Object object = this.getFlash(facesContext);
            return var3_27;
        } else if (varName.equals(HTTP_SESSION_SCOPE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            PortletSession portletSession = (PortletSession)externalContext.getSession(true);
            PortletConfig portletConfig = RequestMapUtil.getPortletConfig(portletRequest);
            PortletContext portletContext = portletConfig.getPortletContext();
            boolean preferPreDestroy = PortletConfigParam.PreferPreDestroy.getBooleanValue(portletConfig);
            ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, ContextMapFactory.class);
            Map<String, Object> map = contextMapFactory.getSessionScopeMap(portletContext, portletSession, 1, preferPreDestroy);
            return var3_27;
        } else if (varName.equals(MUTABLE_PORTLET_PREFERENCES_VALUES)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            PortletRequest portletRequest = this.getPortletRequest(facesContext);
            if (portletRequest == null) return var3_27;
            MutablePreferenceMap mutablePreferenceMap = new MutablePreferenceMap(portletRequest.getPreferences());
            return var3_27;
        } else if (varName.equals(PORTLET_SESSION)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Object object = facesContext.getExternalContext().getSession(true);
            return var3_27;
        } else if (varName.equals(PORTLET_SESSION_SCOPE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map map = facesContext.getExternalContext().getSessionMap();
            return var3_27;
        } else if (varName.equals(PORTLET_PREFERENCES)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            PortletRequest portletRequest = this.getPortletRequest(facesContext);
            if (portletRequest == null) return var3_27;
            PortletPreferences portletPreferences = portletRequest.getPreferences();
            return var3_27;
        } else if (varName.equals(PORTLET_PREFERENCES_VALUES)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            PortletRequest portletRequest = this.getPortletRequest(facesContext);
            if (portletRequest == null) return var3_27;
            Map map = portletRequest.getPreferences().getMap();
            return var3_27;
        } else if (varName.equals(RENDER_REQUEST)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.HEADER_PHASE && portletPhase != Bridge.PortletPhase.RENDER_PHASE) throw new ELException("Unable to get renderRequest during " + portletPhase);
            PortletRequest portletRequest = this.getPortletRequest(facesContext);
            return var3_27;
        } else if (varName.equals(RENDER_RESPONSE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.HEADER_PHASE && portletPhase != Bridge.PortletPhase.RENDER_PHASE) throw new ELException("Unable to get renderResponse during " + portletPhase);
            PortletResponse portletResponse = this.getPortletResponse(facesContext);
            return var3_27;
        } else if (varName.equals(RESOURCE_REQUEST)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.RESOURCE_PHASE) throw new ELException("Unable to get resourceRequest during " + portletPhase);
            PortletRequest portletRequest = this.getPortletRequest(facesContext);
            return var3_27;
        } else if (varName.equals(RESOURCE_RESPONSE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase != Bridge.PortletPhase.RESOURCE_PHASE) throw new ELException("Unable to get renderResponse during " + portletPhase);
            PortletResponse portletResponse = this.getPortletResponse(facesContext);
            return var3_27;
        } else {
            Object object = super.resolveVariable(elContext, varName);
        }
        return var3_27;
    }

    private boolean canHandleVar(Object property) {
        return property instanceof String && (this.isFacesContextVar((String)property) || JSP_CONTEXT_VAR_NAMES.contains(property));
    }

    static {
        HashSet<String> facesContextVarNames = new HashSet<String>();
        facesContextVarNames.add(ACTION_REQUEST);
        facesContextVarNames.add(ACTION_RESPONSE);
        facesContextVarNames.add(BRIDGE_CONTEXT);
        facesContextVarNames.add(EVENT_REQUEST);
        facesContextVarNames.add(EVENT_RESPONSE);
        facesContextVarNames.add(FLASH);
        facesContextVarNames.add(HTTP_SESSION_SCOPE);
        facesContextVarNames.add(MUTABLE_PORTLET_PREFERENCES_VALUES);
        facesContextVarNames.add(PORTLET_CONFIG);
        facesContextVarNames.add(PORTLET_SESSION);
        facesContextVarNames.add(PORTLET_SESSION_SCOPE);
        facesContextVarNames.add(PORTLET_PREFERENCES);
        facesContextVarNames.add(PORTLET_PREFERENCES_VALUES);
        facesContextVarNames.add(RENDER_REQUEST);
        facesContextVarNames.add(RENDER_RESPONSE);
        facesContextVarNames.add(RESOURCE_REQUEST);
        facesContextVarNames.add(RESOURCE_RESPONSE);
        FACES_CONTEXT_VAR_NAMES = Collections.unmodifiableSet(facesContextVarNames);
        HashSet<String> jspContextVarName = new HashSet<String>();
        jspContextVarName.add(HTTP_SESSION_SCOPE);
        jspContextVarName.add(MUTABLE_PORTLET_PREFERENCES_VALUES);
        JSP_CONTEXT_VAR_NAMES = Collections.unmodifiableSet(jspContextVarName);
        ArrayList<FeatureDescriptor> featureDescriptors = new ArrayList<FeatureDescriptor>();
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(ACTION_REQUEST, ActionRequest.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(ACTION_RESPONSE, ActionResponse.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(BRIDGE_CONTEXT, LegacyBridgeContext.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(EVENT_REQUEST, EventRequest.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(EVENT_RESPONSE, EventResponse.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(FLASH, Flash.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(HTTP_SESSION_SCOPE, Map.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(MUTABLE_PORTLET_PREFERENCES_VALUES, Map.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(PORTLET_CONFIG, PortletConfig.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(PORTLET_SESSION, PortletSession.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(PORTLET_SESSION_SCOPE, Map.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(PORTLET_PREFERENCES, PortletPreferences.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(PORTLET_PREFERENCES_VALUES, Map.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(RENDER_REQUEST, RenderRequest.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(RENDER_RESPONSE, RenderResponse.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(RESOURCE_REQUEST, ResourceRequest.class));
        featureDescriptors.add(ELResolverImpl.getFeatureDescriptor(RESOURCE_RESPONSE, ResourceResponse.class));
        featureDescriptors.addAll(FEATURE_DESCRIPTORS_COMPAT);
        FEATURE_DESCRIPTORS = Collections.unmodifiableList(featureDescriptors);
    }
}

