/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.util.context.map.FacesRequestParameterMap;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.model.UploadedFileFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.portlet.ActionParameters;
import javax.portlet.ActionRequest;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.ResourceRequest;
import javax.portlet.faces.BridgeFactoryFinder;
import javax.servlet.http.Part;

public abstract class MultiPartFormDataProcessorCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(MultiPartFormDataProcessorCompatImpl.class);

    protected abstract void addUploadedFile(Map<String, List<UploadedFile>> var1, String var2, UploadedFile var3);

    protected abstract String stripIllegalCharacters(String var1);

    Map<String, List<UploadedFile>> iterateOver(ClientDataRequest clientDataRequest, PortletConfig portletConfig, FacesRequestParameterMap facesRequestParameterMap, File uploadedFilesPath, long maxFileSize) {
        ActionParameters portletParameters;
        boolean actionPhase;
        HashMap<String, List<UploadedFile>> uploadedFileMap = new HashMap<String, List<UploadedFile>>();
        if (clientDataRequest instanceof ActionRequest) {
            actionPhase = true;
            ActionRequest actionRequest = (ActionRequest)clientDataRequest;
            portletParameters = actionRequest.getActionParameters();
        } else {
            actionPhase = false;
            ResourceRequest resourceRequest = (ResourceRequest)clientDataRequest;
            portletParameters = resourceRequest.getResourceParameters();
        }
        HashSet fullyQualifiedParameterNames = new HashSet(Collections.list(clientDataRequest.getParameterNames()));
        Set portletParameterNames = portletParameters.getNames();
        for (Object parameterName : portletParameterNames) {
            String[] parameterValues;
            String fullyQualifiedParameterName;
            if (!fullyQualifiedParameterNames.contains(parameterName) && fullyQualifiedParameterNames.contains(fullyQualifiedParameterName = facesRequestParameterMap.getNamespace() + (String)parameterName)) {
                parameterName = fullyQualifiedParameterName;
            }
            if ((parameterValues = portletParameters.getValues((String)parameterName)).length <= 0) continue;
            for (String parameterValue : parameterValues) {
                facesRequestParameterMap.addValue((String)parameterName, parameterValue);
                if (actionPhase) {
                    logger.debug("Added action parameter name={0} value={1}", new Object[]{parameterName, parameterValue});
                    continue;
                }
                logger.debug("Added resource parameter name={0} value={1}", new Object[]{parameterName, parameterValue});
            }
        }
        UploadedFileFactory uploadedFileFactory = (UploadedFileFactory)BridgeFactoryFinder.getFactory((PortletContext)portletConfig.getPortletContext(), UploadedFileFactory.class);
        try {
            Collection parts = clientDataRequest.getParts();
            ArrayList<String> fileUploadFieldNames = new ArrayList<String>();
            int totalFiles = 0;
            for (Part part : parts) {
                if (part.getSize() <= maxFileSize) {
                    String fieldName = part.getName();
                    fileUploadFieldNames.add(fieldName);
                    try {
                        ++totalFiles;
                        String characterEncoding = clientDataRequest.getCharacterEncoding();
                        String contentDispositionHeader = part.getHeader("content-disposition");
                        String fileName = this.getValidFileName(contentDispositionHeader);
                        if (fileName == null || fileName.length() <= 0) continue;
                        File uploadedFilePath = new File(uploadedFilesPath, fileName);
                        String uploadedFilePathAbsolutePath = uploadedFilePath.getAbsolutePath();
                        part.write(uploadedFilePathAbsolutePath);
                        if (uploadedFilePath.exists()) {
                            TreeMap headersMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                            Collection headerNames = part.getHeaderNames();
                            for (String headerName : headerNames) {
                                Collection headerValues = part.getHeaders(headerName);
                                ArrayList<String> headerValueList = new ArrayList<String>();
                                for (String headerValue : headerValues) {
                                    headerValueList.add(headerValue);
                                }
                                headersMap.put(headerName, headerValueList);
                            }
                            HashMap attributeMap = new HashMap();
                            String id = Long.toString((long)this.hashCode() + System.currentTimeMillis());
                            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(uploadedFilePathAbsolutePath, attributeMap, characterEncoding, part.getContentType(), headersMap, id, null, fileName, part.getSize(), UploadedFile.Status.FILE_SAVED);
                            facesRequestParameterMap.addValue(fieldName, uploadedFilePathAbsolutePath);
                            this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                            logger.debug("Received uploaded file fieldName=[{0}] fileName=[{1}]", new Object[]{fieldName, fileName});
                            continue;
                        }
                        if (fileName.trim().length() <= 0) continue;
                        IOException e = new IOException("Failed to copy the stream of uploaded file=[" + fileName + "] to a temporary file (possibly a zero-length uploaded file)");
                        UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile((Exception)e);
                        this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                        String totalFilesfieldName = Integer.toString(totalFiles);
                        this.addUploadedFile(uploadedFileMap, totalFilesfieldName, uploadedFile);
                    }
                    continue;
                }
                logger.warn("Rejecting file name=[{0}] size=[{1}] since it is larger than maxFileSize[{2}]", new Object[]{part.getName(), part.getSize(), maxFileSize});
                part.delete();
            }
            for (String fileUploadFieldName : fileUploadFieldNames) {
                if (uploadedFileMap.containsKey(fileUploadFieldName)) continue;
                uploadedFileMap.put(fileUploadFieldName, Collections.emptyList());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
            this.addUploadedFile(uploadedFileMap, "unknown", uploadedFile);
        }
        return uploadedFileMap;
    }

    private String getValidFileName(String contentDispositionHeader) {
        String[] headerParts;
        for (String headerPart : headerParts = contentDispositionHeader.split(";")) {
            int equalsPos;
            String trimmedHeaderPart = headerPart.trim();
            if (!trimmedHeaderPart.startsWith("filename") || (equalsPos = trimmedHeaderPart.indexOf("=")) <= 0) continue;
            String fileName = trimmedHeaderPart.substring(equalsPos + 1).trim();
            if (fileName.startsWith("\"")) {
                fileName = fileName.substring(1);
            }
            if (fileName.endsWith("\"")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            return this.stripIllegalCharacters(fileName);
        }
        return null;
    }
}

