/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.util.map.AbstractPropertyMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractImmutablePropertyMap<V>
extends AbstractPropertyMap<V> {
    private Set<String> propertyNames;

    public boolean containsKey(Object key) {
        this.initPropertyNames();
        return this.propertyNames.contains(key);
    }

    protected abstract Enumeration<String> getImmutablePropertyNames();

    protected Enumeration<String> getPropertyNames() {
        this.initPropertyNames();
        return Collections.enumeration(this.propertyNames);
    }

    protected void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    protected void setProperty(String name, V value) {
        throw new UnsupportedOperationException();
    }

    private void initPropertyNames() {
        if (this.propertyNames == null) {
            Enumeration<String> attributeNames = this.getImmutablePropertyNames();
            ArrayList<String> attributeNameList = Collections.list(attributeNames);
            this.propertyNames = new LinkedHashSet<String>(attributeNameList);
        }
    }
}

