/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.component.inputfile.internal;

import com.liferay.faces.bridge.component.inputfile.internal.InputFileRenderer;
import com.liferay.faces.bridge.component.inputfile.internal.PartEmptyImpl;
import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.bridge.renderkit.bridge.internal.PartFileUploadAdapterImpl;
import com.liferay.faces.bridge.util.internal.TCCLUtil;
import com.liferay.faces.util.lang.ThreadSafeAccessor;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import com.liferay.faces.util.render.DelegatingRendererBase;
import com.liferay.faces.util.render.RendererUtil;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputFile;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

public class HtmlInputFileRenderer
extends DelegatingRendererBase {
    private static final Logger logger = LoggerFactory.getLogger(HtmlInputFileRenderer.class);
    private final DelegateRendererAccessor delegateRendererAccessor = new DelegateRendererAccessor();

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String clientId;
        HtmlInputFile htmlInputFile = (HtmlInputFile)uiComponent;
        Map<String, List<UploadedFile>> uploadedFileMap = InputFileRenderer.getUploadedFileMap(facesContext);
        if (!uploadedFileMap.isEmpty() && uploadedFileMap.containsKey(clientId = uiComponent.getClientId(facesContext))) {
            List<UploadedFile> uploadedFiles = uploadedFileMap.get(clientId);
            if (uploadedFiles != null && uploadedFiles.size() > 0) {
                PartFileUploadAdapterImpl part = new PartFileUploadAdapterImpl(uploadedFiles.get(0), clientId);
                htmlInputFile.setTransient(true);
                htmlInputFile.setSubmittedValue((Object)part);
            } else {
                htmlInputFile.setSubmittedValue((Object)new PartEmptyImpl());
            }
        }
        RendererUtil.decodeClientBehaviors((FacesContext)facesContext, (UIComponent)uiComponent);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof PartEmptyImpl) {
            return null;
        }
        return submittedValue;
    }

    public String getDelegateComponentFamily() {
        return "javax.faces.Input";
    }

    public Renderer getDelegateRenderer(FacesContext facesContext) {
        return (Renderer)this.delegateRendererAccessor.get(facesContext);
    }

    public String getDelegateRendererType() {
        return "javax.faces.File";
    }

    private static final class NoOpRenderer
    extends Renderer {
        private NoOpRenderer() {
        }
    }

    private static final class DelegateRendererAccessor
    extends ThreadSafeAccessor<Renderer, FacesContext> {
        private DelegateRendererAccessor() {
        }

        protected Renderer computeValue(FacesContext facesContext) {
            Renderer delegateRenderer;
            String delegateRendererFQCN = "com.sun.faces.renderkit.html_basic.FileRenderer";
            ExternalContext externalContext = facesContext.getExternalContext();
            Product MYFACES = ProductFactory.getProductInstance((ExternalContext)externalContext, (Product.Name)Product.Name.MYFACES);
            if (MYFACES.isDetected()) {
                delegateRendererFQCN = "org.apache.myfaces.renderkit.html.HtmlInputFileRenderer";
            }
            try {
                Class<?> delegateRendererClass = TCCLUtil.loadClassFromContext(((Object)((Object)this)).getClass(), delegateRendererFQCN);
                delegateRenderer = (Renderer)delegateRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                delegateRenderer = new NoOpRenderer();
            }
            return delegateRenderer;
        }
    }
}

