/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import javax.faces.application.Resource;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceRichFacesImpl
extends ResourceWrapper {
    public static final String ORG_RICHFACES = "org.richfaces";
    private static final String RICHFACES_PATH_TOKEN = "/rfRes/";
    private Resource wrappedResource;

    public ResourceRichFacesImpl(Resource resource) {
        this.wrappedResource = resource;
    }

    public String getContentType() {
        return this.wrappedResource.getContentType();
    }

    public String getLibraryName() {
        return this.wrappedResource.getLibraryName();
    }

    public String getRequestPath() {
        String requestPath = super.getRequestPath();
        if (requestPath != null) {
            int pos = requestPath.indexOf(RICHFACES_PATH_TOKEN);
            if (pos > 0) {
                requestPath = requestPath.replaceAll("[.]faces", "");
                requestPath = requestPath.replaceAll("[.]jsf", "");
                requestPath = requestPath.replaceAll("[.]xhtml", "");
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ExternalContext externalContext = facesContext.getExternalContext();
                StringBuilder buf = new StringBuilder();
                buf.append("/javax.faces.resource/");
                buf.append(requestPath.substring(pos + RICHFACES_PATH_TOKEN.length()));
                requestPath = externalContext.encodeResourceURL(buf.toString());
            }
            if (requestPath.contains("/javax.faces.resource") && requestPath.contains("javax.faces.resource=")) {
                requestPath = requestPath.replaceFirst("javax.faces.resource=[^&#]*", "");
                if ((requestPath = requestPath.replace("?#", "#").replace("&#", "#").replace("?&", "?")).endsWith("?") || requestPath.endsWith("&")) {
                    requestPath = requestPath.substring(0, requestPath.length() - 1);
                }
            }
        }
        return requestPath;
    }

    public String getResourceName() {
        return this.wrappedResource.getResourceName();
    }

    public Resource getWrapped() {
        return this.wrappedResource;
    }

    public void setContentType(String contentType) {
        this.wrappedResource.setContentType(contentType);
    }

    public void setLibraryName(String libraryName) {
        this.wrappedResource.setLibraryName(libraryName);
    }

    public void setResourceName(String resourceName) {
        this.wrappedResource.setResourceName(resourceName);
    }

    public String toString() {
        return this.wrappedResource.toString();
    }
}

