/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.faces.application.Resource;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeConfig;

public class ResourceInnerImpl
extends ResourceWrapper
implements Serializable {
    private static final long serialVersionUID = 827821821511052062L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceInnerImpl.class);
    private static final String HTTP_SPEC_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String EXTENSION_FACES = ".faces";
    private static final String LIBRARY_NAME_JAVAX_FACES = "javax.faces";
    private static final Set<String> NON_CACHED_RESOURCES;
    private Long lastModifiedInSeconds;
    private Resource wrappedResource;

    public ResourceInnerImpl() {
    }

    public ResourceInnerImpl(Resource wrappedResource) {
        this.wrappedResource = wrappedResource;
    }

    public String getContentType() {
        return this.wrappedResource.getContentType();
    }

    public String getLibraryName() {
        return this.wrappedResource.getLibraryName();
    }

    public String getRequestPath() {
        Object wrappedRequestPath = this.wrappedResource.getRequestPath();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (wrappedRequestPath != null) {
            BridgeConfig bridgeConfig;
            List configuredFacesServletMappings;
            if (((String)wrappedRequestPath).contains("/javax.faces.resource") && facesContext != null && (configuredFacesServletMappings = (List)(bridgeConfig = RequestMapUtil.getBridgeConfig(facesContext)).getAttributes().get("configuredFacesServletMappings")) != null) {
                for (ConfiguredServletMapping configuredServletMapping : configuredFacesServletMappings) {
                    if (!configuredServletMapping.isExtensionMapped()) continue;
                    String extension = configuredServletMapping.getExtension();
                    String token = extension + "?";
                    int pos = ((String)wrappedRequestPath).indexOf(token);
                    if (pos > 0) {
                        wrappedRequestPath = ((String)wrappedRequestPath).substring(0, pos) + ((String)wrappedRequestPath).substring(pos + extension.length());
                        logger.debug("Removed extension=[{0}] from requestPath=[{1}]", new Object[]{extension, wrappedRequestPath});
                        break;
                    }
                    if (!((String)wrappedRequestPath).endsWith(extension) || extension.equals(EXTENSION_FACES) && ((String)wrappedRequestPath).endsWith(LIBRARY_NAME_JAVAX_FACES)) continue;
                    wrappedRequestPath = ((String)wrappedRequestPath).substring(0, ((String)wrappedRequestPath).lastIndexOf(extension));
                    logger.debug("Removed extension=[{0}] from requestPath=[{1}]", new Object[]{extension, wrappedRequestPath});
                    break;
                }
            }
            if (((String)wrappedRequestPath).endsWith("org.richfaces")) {
                String resourcePath = "META-INF/resources/org.richfaces/" + this.getResourceName();
                URL resourceURL = this.getClass().getClassLoader().getResource(resourcePath);
                if (resourceURL != null) {
                    wrappedRequestPath = (String)wrappedRequestPath + ".images";
                }
            }
        }
        return wrappedRequestPath;
    }

    public String getResourceName() {
        return this.wrappedResource.getResourceName();
    }

    public Resource getWrapped() {
        return this.wrappedResource;
    }

    public void setContentType(String contentType) {
        this.wrappedResource.setContentType(contentType);
    }

    public void setLibraryName(String libraryName) {
        this.wrappedResource.setLibraryName(libraryName);
    }

    public void setResourceName(String resourceName) {
        this.wrappedResource.setResourceName(resourceName);
    }

    public String toString() {
        return this.wrappedResource.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userAgentNeedsUpdate(FacesContext facesContext) {
        String resourceName = this.getResourceName();
        boolean needsUpdate = this.wrappedResource.userAgentNeedsUpdate(facesContext);
        if (!needsUpdate) {
            if (NON_CACHED_RESOURCES.contains(resourceName)) {
                needsUpdate = true;
            } else {
                if (this.lastModifiedInSeconds == null) {
                    URL url = this.wrappedResource.getURL();
                    if (url != null) {
                        InputStream inputStream = null;
                        try {
                            URLConnection urlConnection = url.openConnection();
                            urlConnection.setUseCaches(false);
                            urlConnection.connect();
                            inputStream = urlConnection.getInputStream();
                            long lastModifiedInMilliSeconds = urlConnection.getLastModified();
                            this.lastModifiedInSeconds = lastModifiedInMilliSeconds / 1000L;
                        }
                        catch (IOException e) {
                            this.lastModifiedInSeconds = 0L;
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    } else {
                        logger.warn("Unable to determine if user agent needs update because resource URL was null for resourceName=[{0}].", new Object[]{resourceName});
                    }
                }
                if (this.lastModifiedInSeconds != null) {
                    long ifModifiedHeaderInSeconds = 0L;
                    Map requestHeaderMap = facesContext.getExternalContext().getRequestHeaderMap();
                    String requestHeaderValue = (String)requestHeaderMap.get("If-Modified-Since");
                    if (requestHeaderValue != null) {
                        try {
                            SimpleDateFormat httpSpecDateFormat = new SimpleDateFormat(HTTP_SPEC_DATE_PATTERN, Locale.US);
                            httpSpecDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                            long ifModifiedHeaderInMilliSeconds = httpSpecDateFormat.parse(requestHeaderValue).getTime();
                            ifModifiedHeaderInSeconds = ifModifiedHeaderInMilliSeconds / 1000L;
                            if (logger.isDebugEnabled()) {
                                logger.debug("resourceName=[{0}] requestHeaderValue=[{1}] ifModifiedHeaderInSeconds=[{2}]", new Object[]{resourceName, requestHeaderValue, Long.toString(ifModifiedHeaderInSeconds)});
                            }
                        }
                        catch (ParseException e) {
                            logger.error("Unable to parse request-header=[{0}] value=[{1}]", new Object[]{"If-Modified-Since", requestHeaderValue});
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("resourceName=[{0}] lastModified=[{1}] ifModifiedHeaderInSeconds=[{2}]", new Object[]{resourceName, Long.toString(this.lastModifiedInSeconds), Long.toString(ifModifiedHeaderInSeconds)});
                    }
                    needsUpdate = this.lastModifiedInSeconds > ifModifiedHeaderInSeconds;
                }
            }
        }
        logger.debug("resourceName=[{0}] needsUpdate=[{1}]", new Object[]{resourceName, needsUpdate});
        return needsUpdate;
    }

    static {
        HashSet<String> nonCachedResources = new HashSet<String>();
        nonCachedResources.add("jsf.js");
        nonCachedResources.add("bridge.js");
        nonCachedResources.add("bridge.uncompressed.js");
        nonCachedResources.add("compat.js");
        nonCachedResources.add("compat.uncompressed.js");
        nonCachedResources.add("icefaces-compat.js");
        nonCachedResources.add("icefaces-compat.uncompressed.js");
        nonCachedResources.add("icepush.js");
        nonCachedResources.add("icepush.uncompressed.js");
        nonCachedResources.add("compat.js");
        nonCachedResources.add("icefaces-compat.js");
        NON_CACHED_RESOURCES = Collections.unmodifiableSet(nonCachedResources);
    }
}

