/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.ResourceRichFacesCSSImpl;
import com.liferay.faces.bridge.application.internal.ResourceRichFacesImpl;
import com.liferay.faces.bridge.application.internal.ResourceRichFacesPackedJSImpl;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceHandlerRichfacesImpl
extends ResourceHandlerWrapper {
    private static final String ORG_RICHFACES_RESOURCE = "org.richfaces.resource";
    private static final String RICHFACES_STATIC_RESOURCE = "org.richfaces.staticResource";
    private ResourceHandler wrappedResourceHandler;

    public ResourceHandlerRichfacesImpl(ResourceHandler wrappedResourceHandler) {
        this.wrappedResourceHandler = wrappedResourceHandler;
    }

    public Resource createResource(String resourceName) {
        Resource resource = super.createResource(resourceName);
        resource = this.createResource(resourceName, resource);
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource resource = super.createResource(resourceName, libraryName);
        resource = this.createResource(resourceName, resource);
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource resource = super.createResource(resourceName, libraryName, contentType);
        resource = this.createResource(resourceName, resource);
        return resource;
    }

    public ResourceHandler getWrapped() {
        return this.wrappedResourceHandler;
    }

    private Resource createResource(String resourceName, Resource resource) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Product RICHFACES = ProductFactory.getProductInstance((ExternalContext)externalContext, (Product.Name)Product.Name.RICHFACES);
        boolean RICHFACES_DETECTED = RICHFACES.isDetected();
        if (resource != null && RICHFACES_DETECTED) {
            if (resourceName.startsWith(RICHFACES_STATIC_RESOURCE) && resourceName.endsWith(".css")) {
                resource = new ResourceRichFacesCSSImpl((Resource)resource);
            } else if (resourceName.startsWith(RICHFACES_STATIC_RESOURCE) && resourceName.endsWith("packed.js")) {
                resource = new ResourceRichFacesPackedJSImpl((Resource)resource);
            } else if (resource.getClass().getName().startsWith(ORG_RICHFACES_RESOURCE)) {
                resource = new ResourceRichFacesImpl((Resource)resource);
            }
        }
        return resource;
    }
}

