/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.servlet;

import com.liferay.faces.bridge.bean.BeanManager;
import com.liferay.faces.bridge.bean.BeanManagerFactory;
import com.liferay.faces.bridge.bean.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.context.internal.PortletContextAdapter;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManagerFactory;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.lang.ThreadSafeAccessor;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.util.Enumeration;
import javax.portlet.PortletContext;
import javax.portlet.faces.BridgeFactoryFinder;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class BridgeSessionListener
implements HttpSessionListener,
ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(BridgeSessionListener.class);
    private static final String MOJARRA_ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    private static final String MOJARRA_PACKAGE_PREFIX = "com.sun.faces";
    private static final String MOJARRA_VIEW_SCOPE_MANAGER = "com.sun.faces.application.view.viewScopeManager";
    private final MojarraAbleToCleanUpViewScopedDataAccessor mojarraAbleToCleanUpViewScopedDataAccessor = new MojarraAbleToCleanUpViewScopedDataAccessor();
    private boolean firstInstance;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        PortletContextAdapter portletContext = new PortletContextAdapter(servletContext);
        BridgeFactoryFinder.getInstance().releaseFactories((PortletContext)portletContext);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        if (servletContext.getAttribute(BridgeSessionListener.class.getName()) == null) {
            logger.info("Context initialized for contextPath=[{0}]", new Object[]{servletContext.getContextPath()});
            servletContext.setAttribute(BridgeSessionListener.class.getName(), (Object)Boolean.TRUE);
            this.firstInstance = true;
        } else {
            logger.debug("Preventing multiple instantiation for contextPath=[{0}]", new Object[]{servletContext.getContextPath()});
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        ServletContext servletContext = httpSession.getServletContext();
        PortletContextAdapter portletContext = new PortletContextAdapter(servletContext);
        BridgeFactoryFinder.getFactory((PortletContext)portletContext, BeanManagerFactory.class);
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.firstInstance) {
            BeanManagerFactory beanManagerFactory = null;
            BridgeRequestScopeManagerFactory bridgeRequestScopeManagerFactory = null;
            HttpSession httpSession = null;
            ServletContext servletContext = null;
            PortletContextAdapter portletContext = null;
            try {
                httpSession = httpSessionEvent.getSession();
                servletContext = httpSession.getServletContext();
                portletContext = new PortletContextAdapter(servletContext);
                beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BeanManagerFactory.class);
                bridgeRequestScopeManagerFactory = (BridgeRequestScopeManagerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BridgeRequestScopeManagerFactory.class);
            }
            catch (Exception e) {
                String contextPath = "unknown";
                if (servletContext != null) {
                    contextPath = servletContext.getContextPath();
                }
                logger.error("Unable to discover factories for contextPath=[{0}] possibly because the portlet never received a RenderRequest", new Object[]{contextPath});
            }
            if (beanManagerFactory != null && bridgeRequestScopeManagerFactory != null) {
                BridgeRequestScopeManager bridgeRequestScopeManager = bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager(portletContext);
                bridgeRequestScopeManager.removeBridgeRequestScopesBySession(httpSession);
                String appConfigAttrName = ApplicationConfig.class.getName();
                ApplicationConfig applicationConfig = (ApplicationConfig)servletContext.getAttribute(appConfigAttrName);
                BeanManager beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
                try {
                    Enumeration attributeNames = httpSession.getAttributeNames();
                    while (attributeNames.hasMoreElements()) {
                        HttpSessionListener viewScopeManager;
                        int pos;
                        String attributeName = (String)attributeNames.nextElement();
                        if (attributeName == null || !attributeName.startsWith("javax.portlet.p.") || (pos = attributeName.indexOf("?")) <= 0) continue;
                        Object attributeValue = httpSession.getAttribute(attributeName);
                        httpSession.removeAttribute(attributeName);
                        if (attributeValue == null) continue;
                        if (beanManager.isManagedBean(attributeName, attributeValue)) {
                            PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, PreDestroyInvokerFactory.class);
                            PreDestroyInvoker preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(servletContext);
                            preDestroyInvoker.invokeAnnotatedMethods(attributeValue, true);
                            continue;
                        }
                        String attributeValueClassName = attributeValue.getClass().getName();
                        if (!attributeName.contains(MOJARRA_ACTIVE_VIEW_MAPS) && !attributeValueClassName.contains(MOJARRA_PACKAGE_PREFIX)) continue;
                        String nonPrefixedName = attributeName.substring(pos + 1);
                        logger.debug("Renaming Mojarra session attributeName=[{0}] -> [{1}]", new Object[]{attributeName, nonPrefixedName});
                        httpSession.setAttribute(nonPrefixedName, attributeValue);
                        if (!MOJARRA_ACTIVE_VIEW_MAPS.equals(nonPrefixedName) || !((Boolean)this.mojarraAbleToCleanUpViewScopedDataAccessor.get(portletContext)).booleanValue() || (viewScopeManager = (HttpSessionListener)servletContext.getAttribute(MOJARRA_VIEW_SCOPE_MANAGER)) == null) continue;
                        try {
                            logger.debug("Asking Mojarra ViewScopeManager to cleanup @ViewScoped managed-beans");
                            viewScopeManager.sessionDestroyed(httpSessionEvent);
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
                catch (IllegalStateException e) {
                    logger.warn("Server does not permit cleanup of Mojarra managed-beans during session expiration");
                }
            }
        }
    }

    private static final class MojarraAbleToCleanUpViewScopedDataAccessor
    extends ThreadSafeAccessor<Boolean, PortletContext> {
        private MojarraAbleToCleanUpViewScopedDataAccessor() {
        }

        protected Boolean computeValue(PortletContext portletContext) {
            ProductFactory productFactory = (ProductFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, ProductFactory.class);
            Product mojarra = productFactory.getProductInfo(Product.Name.MOJARRA);
            boolean mojarraAbleToCleanup = true;
            if (mojarra.isDetected() && mojarra.getMajorVersion() == 2 && mojarra.getMinorVersion() == 1 && mojarra.getPatchVersion() < 18) {
                mojarraAbleToCleanup = false;
                boolean logWarning = true;
                Product iceFaces = productFactory.getProductInfo(Product.Name.ICEFACES);
                if (iceFaces.isDetected() && (iceFaces.getMajorVersion() == 2 || iceFaces.getMajorVersion() == 3 && iceFaces.getMinorVersion() <= 2)) {
                    logWarning = false;
                }
                if (logWarning) {
                    logger.warn("Unable to cleanup ViewScoped managed-beans upon session expiration. Please upgrade to Mojarra 2.1.18 or newer. For more info, see: http://issues.liferay.com/browse/FACES-1470");
                }
            }
            return mojarraAbleToCleanup;
        }
    }
}

