/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.NodeListImpl;
import java.util.Collections;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
implements Node {
    private short nodeType;
    private String textContent;
    private Node parentNode;
    private NodeListImpl childNodes;

    public NodeImpl(short nodeType, Node parentNode) {
        this.nodeType = nodeType;
        this.parentNode = parentNode;
        this.childNodes = new NodeListImpl();
    }

    public NodeImpl(short nodeType, String textContent, Node parentNode) {
        this(nodeType, parentNode);
        this.textContent = textContent;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        this.childNodes.add(newChild);
        return newChild;
    }

    @Override
    public Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedNodeMap getAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList getChildNodes() {
        return this.childNodes;
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getFirstChild() {
        return this.childNodes.item(0);
    }

    @Override
    public Node getLastChild() {
        int length = this.childNodes.getLength();
        return this.childNodes.item(length - 1);
    }

    @Override
    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getNextSibling() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNodeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getNodeValue() throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Document getOwnerDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getPreviousSibling() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTextContent() throws DOMException {
        if (this.textContent == null) {
            this.textContent = "";
            int childNodeCount = this.childNodes.getLength();
            for (int i = 0; i < childNodeCount; ++i) {
                Node childNode = this.childNodes.item(i);
                this.textContent = this.textContent + childNode.getTextContent();
            }
        }
        return this.textContent;
    }

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasChildNodes() {
        return !this.childNodes.isEmpty();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        int index = this.childNodes.indexOf(refChild);
        this.childNodes.add(index, newChild);
        return newChild;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void normalize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        this.childNodes.remove(oldChild);
        return oldChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        Collections.replaceAll(this.childNodes, oldChild, newChild);
        return oldChild;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.textContent = textContent;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException();
    }
}

