/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.ElementImpl;
import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadResponseWriterBase;
import com.liferay.faces.bridge.renderkit.html_basic.internal.NodeImpl;
import com.liferay.faces.bridge.renderkit.html_basic.internal.RenderKitUtil;
import com.liferay.faces.bridge.util.internal.XMLUtil;
import com.liferay.faces.util.lang.ThreadSafeAccessor;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.HeaderResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HeadResponseWriterCompatImpl
extends HeadResponseWriterBase {
    private static final Logger logger = LoggerFactory.getLogger(HeadResponseWriterCompatImpl.class);
    private final HeaderResponse headerResponse;
    private final BootsFacesDetectedAccessor bootsFacesDetectedAccessor = new BootsFacesDetectedAccessor();

    public HeadResponseWriterCompatImpl(ResponseWriter wrappedResponseWriter, HeaderResponse headerResponse) {
        super(wrappedResponseWriter);
        this.headerResponse = headerResponse;
    }

    public Writer append(CharSequence csq) throws IOException {
        if (csq != null) {
            String text = csq.toString();
            if ("<![CDATA[".equalsIgnoreCase(text.toUpperCase(Locale.ENGLISH))) {
                this.startCDATA();
            } else if ("]]>".equalsIgnoreCase(text)) {
                this.endCDATA();
            } else {
                this.addNodeToHeadSection((short)3, csq);
            }
        }
        return this;
    }

    public void endCDATA() throws IOException {
        Node currentNode = this.getCurrentNode();
        if (currentNode.getNodeType() != 4) {
            throw new IllegalArgumentException("ResponseWriter.endCDATA() called before startCDATA().");
        }
        Node parentNode = currentNode.getParentNode();
        if (parentNode != null) {
            this.setCurrentNode(parentNode);
        } else {
            this.writeNodeToHeadSection(currentNode, null);
            this.setCurrentNode(null);
        }
    }

    public void startCDATA() throws IOException {
        Node currentNode = this.getCurrentNode();
        NodeImpl cdataNode = new NodeImpl(4, currentNode);
        if (currentNode != null) {
            if (4 == currentNode.getNodeType()) {
                throw new IllegalStateException("CDATA cannot be nested.");
            }
            currentNode.appendChild(cdataNode);
        }
        this.setCurrentNode(cdataNode);
    }

    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            this.addNodeToHeadSection((short)8, XMLUtil.escapeXML(comment.toString()));
        }
    }

    @Override
    protected Node createElement(String nodeName) {
        return new ElementImpl(nodeName, this.getCurrentNode());
    }

    @Override
    protected void writeNodeToHeadSection(Node node, UIComponent componentResource) throws IOException {
        String nodeString;
        String name = null;
        String scope = null;
        String version = null;
        if (this.isElement(node)) {
            Element element = (Element)node;
            if (componentResource != null && (RenderKitUtil.isScriptResource(componentResource, (Boolean)this.bootsFacesDetectedAccessor.get(null)) || RenderKitUtil.isStyleSheetResource(componentResource, (Boolean)this.bootsFacesDetectedAccessor.get(null)))) {
                Map attributes = componentResource.getAttributes();
                name = (String)attributes.get("name");
                scope = (String)attributes.get("library");
                version = (String)attributes.get("portlet:version");
                boolean obtainComponentResourceVersionFromURL = false;
                if (version == null && obtainComponentResourceVersionFromURL) {
                    int queryIndex;
                    String url = element.getAttribute("src");
                    if (url == null || url.equals("")) {
                        url = element.getAttribute("href");
                    }
                    if ((queryIndex = url.indexOf("?")) > 0) {
                        int indexOfAmpersand;
                        String queryString = url.substring(queryIndex + 1);
                        int versionStartIndex = this.getParameterValueStartIndex(queryString, "v");
                        if (versionStartIndex > -1) {
                            versionStartIndex = this.getParameterValueStartIndex(queryString, "version");
                        }
                        if (versionStartIndex > -1 && (indexOfAmpersand = (version = queryString.substring(versionStartIndex)).indexOf("&")) > -1) {
                            version = version.substring(0, indexOfAmpersand);
                        }
                    }
                }
            }
            nodeString = XMLUtil.elementToString(node, true);
        } else {
            nodeString = XMLUtil.nodeToString(node);
        }
        if (name == null) {
            name = Integer.toString(node.hashCode()) + Integer.toString(this.headerResponse.hashCode());
        }
        if (nodeString == null || nodeString.startsWith("<!--[") && nodeString.endsWith("]>") || nodeString.startsWith("<![>") || nodeString.endsWith("]-->") || nodeString.startsWith("<meta")) {
            logger.debug("Not adding BootsFaces dependency: [{0}]", new Object[]{nodeString});
            return;
        }
        this.headerResponse.addDependency(name, scope, version, nodeString);
        if (logger.isDebugEnabled()) {
            logger.debug("Added resource to Liferay's <head>...</head> section, node=[{0}]", new Object[]{this.getNodeInfo(node)});
        }
    }

    private void addNodeToHeadSection(short nodeType, Object text) throws IOException {
        Node currentNode = this.getCurrentNode();
        if (currentNode != null) {
            currentNode.appendChild(new NodeImpl(nodeType, text.toString(), currentNode));
        } else {
            this.writeNodeToHeadSection(new NodeImpl(nodeType, text.toString(), null), null);
        }
    }

    private int getParameterValueStartIndex(String queryString, String parameterName) {
        int parameterValueStartIndex = -1;
        String parameterEqual = parameterName + "=";
        String andParameterEqual = "&" + parameterEqual;
        if (queryString.startsWith(parameterEqual)) {
            parameterValueStartIndex = queryString.indexOf(parameterEqual) + parameterEqual.length();
        } else if (queryString.contains(andParameterEqual) && (parameterValueStartIndex = queryString.indexOf(andParameterEqual)) > -1) {
            parameterValueStartIndex += andParameterEqual.length();
        }
        return parameterValueStartIndex;
    }

    private static final class BootsFacesDetectedAccessor
    extends ThreadSafeAccessor<Boolean, Void> {
        private BootsFacesDetectedAccessor() {
        }

        protected Boolean computeValue(Void null_) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            Product BOOTSFACES = ProductFactory.getProductInstance((ExternalContext)externalContext, (Product.Name)Product.Name.BOOTSFACES);
            return BOOTSFACES.isDetected();
        }
    }
}

