/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.event.internal;

import com.liferay.faces.bridge.event.internal.PublicRenderParameterImpl;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeConfig;
import javax.portlet.faces.BridgePublicRenderParameterHandler;
import javax.portlet.faces.BridgePublicRenderParameterHandlerFactory;
import javax.portlet.faces.BridgeUtil;

public class IPCPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 454155161145961729L;
    private static final Logger logger = LoggerFactory.getLogger(IPCPhaseListener.class);

    public void afterPhase(PhaseEvent phaseEvent) {
        Bridge.PortletPhase portletPhase;
        FacesContext facesContext = phaseEvent.getFacesContext();
        PhaseId phaseId = phaseEvent.getPhaseId();
        if (phaseId == PhaseId.RESTORE_VIEW) {
            this.processIncomingPublicRenderParameters(facesContext);
            Bridge.PortletPhase portletPhase2 = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletPhase2 == Bridge.PortletPhase.EVENT_PHASE) {
                facesContext.renderResponse();
            }
        } else if (phaseId == PhaseId.INVOKE_APPLICATION && ((portletPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext)) == Bridge.PortletPhase.ACTION_PHASE || portletPhase == Bridge.PortletPhase.EVENT_PHASE)) {
            this.processOutgoingPublicRenderParameters(facesContext);
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void processIncomingPublicRenderParameters(FacesContext facesContext) {
        block13: {
            try {
                ExternalContext externalContext;
                PortletRequest portletRequest;
                BridgeConfig bridgeConfig;
                Map publicParameterMappings;
                if (facesContext == null || (publicParameterMappings = (bridgeConfig = RequestMapUtil.getBridgeConfig(portletRequest = (PortletRequest)(externalContext = facesContext.getExternalContext()).getRequest())).getPublicParameterMappings()) == null) break block13;
                boolean invokeHandler = false;
                PortletConfig portletConfig = RequestMapUtil.getPortletConfig(portletRequest);
                String portletName = portletConfig.getPortletName();
                Map publicParameterMap = portletRequest.getPublicParameterMap();
                Set publicRenderParameterNames = publicParameterMappings.keySet();
                for (String prefixedParameterName : publicRenderParameterNames) {
                    String nonPrefixedParameterName;
                    String parameterPrefix;
                    String[] modelExpressions = (String[])publicParameterMappings.get(prefixedParameterName);
                    if (modelExpressions == null) continue;
                    int colonPos = prefixedParameterName.indexOf(":");
                    if (colonPos > 0) {
                        parameterPrefix = prefixedParameterName.substring(0, colonPos);
                        nonPrefixedParameterName = prefixedParameterName.substring(colonPos + 1);
                    } else {
                        parameterPrefix = null;
                        nonPrefixedParameterName = prefixedParameterName;
                    }
                    if (publicParameterMap.containsKey(nonPrefixedParameterName)) {
                        for (String originalModelEL : modelExpressions) {
                            String[] parameterValues = (String[])publicParameterMap.get(nonPrefixedParameterName);
                            String parameterValue = null;
                            if (parameterValues != null && parameterValues.length > 0) {
                                parameterValue = parameterValues[0];
                            }
                            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(parameterPrefix, parameterValue, originalModelEL, portletName);
                            if (logger.isTraceEnabled()) {
                                logger.trace("portletName=[{0}] public render parameter=[{1}] originalModelEL=[{2}] modifiedModelEL=[{3}] isForThisPortlet=[{4}]", new Object[]{portletName, nonPrefixedParameterName, originalModelEL, publicRenderParameter.getModifiedModelEL(), publicRenderParameter.isForThisPortlet()});
                            }
                            if (publicRenderParameter.isForThisPortlet()) {
                                logger.debug("Injecting render parameter=[{0}] value=[{1}] into expression=[{2}]", new Object[]{nonPrefixedParameterName, parameterValue, publicRenderParameter.getModifiedModelEL()});
                                invokeHandler = publicRenderParameter.injectIntoModel(facesContext);
                                continue;
                            }
                            logger.debug("NOT injecting render parameter=[{0}] value=[{1}] into expression=[{2}] because it is NOT for this portletName=[{3}]", new Object[]{nonPrefixedParameterName, parameterValue, publicRenderParameter.getModifiedModelEL(), portletName});
                        }
                        continue;
                    }
                    logger.debug("NOT injecting render parameter=[{0}] because it is not found in the public parameter map", new Object[]{nonPrefixedParameterName});
                }
                if (invokeHandler) {
                    String bridgePublicRenderParameterHandlerAttributeName = "javax.portlet.faces." + portletName + "." + "bridgePublicRenderParameterHandler";
                    logger.trace("bridgePublicRenderParameterHandlerAttributeName=[{0}]", new Object[]{bridgePublicRenderParameterHandlerAttributeName});
                    BridgePublicRenderParameterHandler bridgePublicRenderParameterHandler = (BridgePublicRenderParameterHandler)externalContext.getApplicationMap().get(bridgePublicRenderParameterHandlerAttributeName);
                    if (bridgePublicRenderParameterHandler == null) {
                        bridgePublicRenderParameterHandler = BridgePublicRenderParameterHandlerFactory.getBridgePublicRenderParameterHandlerInstance((PortletConfig)portletConfig);
                    }
                    if (bridgePublicRenderParameterHandler != null) {
                        logger.debug("Invoking {0} for class=[{1}]", new Object[]{bridgePublicRenderParameterHandler, bridgePublicRenderParameterHandler.getClass()});
                        bridgePublicRenderParameterHandler.processUpdates(facesContext);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public void processOutgoingPublicRenderParameters(FacesContext facesContext) {
        try {
            if (facesContext != null) {
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                StateAwareResponse stateAwareResponse = (StateAwareResponse)externalContext.getResponse();
                BridgeConfig bridgeConfig = RequestMapUtil.getBridgeConfig(portletRequest);
                Map publicParameterMappings = bridgeConfig.getPublicParameterMappings();
                if (publicParameterMappings != null) {
                    PortletConfig portletConfig = RequestMapUtil.getPortletConfig(portletRequest);
                    String portletName = portletConfig.getPortletName();
                    Map publicParameterMap = portletRequest.getPublicParameterMap();
                    Set publicRenderParameterNames = publicParameterMappings.keySet();
                    for (String prefixedParameterName : publicRenderParameterNames) {
                        String nonPrefixedParameterName;
                        String parameterPrefix;
                        String[] modelExpressions = (String[])publicParameterMappings.get(prefixedParameterName);
                        if (modelExpressions == null) continue;
                        int colonPos = prefixedParameterName.indexOf(":");
                        if (colonPos > 0) {
                            parameterPrefix = prefixedParameterName.substring(0, colonPos);
                            nonPrefixedParameterName = prefixedParameterName.substring(colonPos + 1);
                        } else {
                            parameterPrefix = null;
                            nonPrefixedParameterName = prefixedParameterName;
                        }
                        for (String originalModelEL : modelExpressions) {
                            PublicRenderParameterImpl publicRenderParameter;
                            String[] parameterValues = (String[])publicParameterMap.get(nonPrefixedParameterName);
                            String parameterValue = null;
                            if (parameterValues != null && parameterValues.length > 0) {
                                parameterValue = parameterValues[0];
                            }
                            if ((publicRenderParameter = new PublicRenderParameterImpl(parameterPrefix, parameterValue, originalModelEL, portletName)).isForThisPortlet()) {
                                String modelValue = publicRenderParameter.getModelValue(facesContext);
                                boolean modelValueHasChanged = publicRenderParameter.isModelValueChanged(facesContext);
                                if (logger.isTraceEnabled()) {
                                    logger.trace("portletName=[{0}] public render parameter=[{1}] parameterValue=[{2}] modelValue=[{3}] modelValueHasChanged=[{4}]", new Object[]{portletName, nonPrefixedParameterName, parameterValue, modelValue, modelValueHasChanged});
                                }
                                if (modelValueHasChanged) {
                                    logger.debug("Setting render parameter=[{0}] in response because modelValue=[{1}] has changed", new Object[]{nonPrefixedParameterName, modelValue});
                                    MutableRenderParameters mutableRenderParameters = stateAwareResponse.getRenderParameters();
                                    mutableRenderParameters.setValue(nonPrefixedParameterName, modelValue);
                                    continue;
                                }
                                logger.debug("NOT setting render parameter=[{0}] in response because modelValue=[{1}] has NOT changed", new Object[]{nonPrefixedParameterName, modelValue});
                                continue;
                            }
                            logger.debug("NOT setting render parameter=[{0}] in response because it is NOT for this portletName=[{1}]", new Object[]{nonPrefixedParameterName, portletName});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

