/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.bean.BeanManager;
import com.liferay.faces.bridge.bean.BeanManagerFactory;
import com.liferay.faces.bridge.bean.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.context.map.internal.AbstractMutablePropertyMap;
import com.liferay.faces.bridge.context.map.internal.SessionScopeMapEntry;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.faces.BridgeFactoryFinder;

public class SessionScopeMap
extends AbstractMutablePropertyMap<Object> {
    private BeanManager beanManager;
    private PortletSession portletSession;
    private PreDestroyInvoker preDestroyInvoker;
    private boolean preferPreDestroy;
    private int scope;

    public SessionScopeMap(PortletContext portletContext, PortletSession portletSession, int scope, boolean preferPreDestroy) {
        String appConfigAttrName = ApplicationConfig.class.getName();
        ApplicationConfig applicationConfig = (ApplicationConfig)portletContext.getAttribute(appConfigAttrName);
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BeanManagerFactory.class);
        this.beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
        PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, PreDestroyInvokerFactory.class);
        this.preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(portletContext);
        this.portletSession = portletSession;
        this.preferPreDestroy = preferPreDestroy;
        this.scope = scope;
    }

    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBeanValue;
                String potentialManagedBeanName = (String)mapEntry.getKey();
                if (!this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue = mapEntry.getValue())) continue;
                this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    public Object remove(Object key) {
        String potentialManagedBeanName = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue)) {
            this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new SessionScopeMapEntry(this.portletSession, name, this.scope);
    }

    @Override
    protected Object getMutableProperty(String name) {
        return this.portletSession.getAttribute(name, this.scope);
    }

    @Override
    protected Enumeration<String> getMutablePropertyNames() {
        return this.portletSession.getAttributeNames(this.scope);
    }

    @Override
    protected void removeMutableProperty(String name) {
        this.portletSession.removeAttribute(name, this.scope);
    }

    @Override
    protected void setMutableProperty(String name, Object value) {
        this.portletSession.setAttribute(name, value, this.scope);
    }
}

