/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.util.map.AbstractPropertyMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractMutablePropertyMap<V>
extends AbstractPropertyMap<V> {
    private Set<String> propertyNames;

    public boolean containsKey(Object key) {
        this.initPropertyNames();
        return this.propertyNames.contains(key);
    }

    protected abstract V getMutableProperty(String var1);

    protected abstract Enumeration<String> getMutablePropertyNames();

    protected abstract void removeMutableProperty(String var1);

    protected abstract void setMutableProperty(String var1, V var2);

    protected V getProperty(String name) {
        return this.getMutableProperty(name);
    }

    protected Enumeration<String> getPropertyNames() {
        this.initPropertyNames();
        return Collections.enumeration(this.propertyNames);
    }

    protected void removeProperty(String name) {
        if (this.propertyNames != null) {
            this.propertyNames.remove(name);
        }
        this.removeMutableProperty(name);
    }

    protected void setProperty(String name, V value) {
        if (this.propertyNames != null) {
            if (value == null) {
                this.propertyNames = null;
            } else if (!this.propertyNames.contains(name)) {
                this.propertyNames.add(name);
            }
        }
        this.setMutableProperty(name, value);
    }

    private void initPropertyNames() {
        if (this.propertyNames == null) {
            Enumeration<String> attributeNames = this.getMutablePropertyNames();
            ArrayList<String> attributeNameList = Collections.list(attributeNames);
            this.propertyNames = new LinkedHashSet<String>(attributeNameList);
        }
    }
}

