/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.BridgeNavigationCaseImpl;
import com.liferay.faces.bridge.application.internal.BridgeNavigationHandlerCompatImpl;
import com.liferay.faces.bridge.application.internal.BridgeNavigationUtil;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.bridge.util.internal.ViewUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.BridgeFactoryFinder;
import javax.portlet.faces.BridgeURL;
import javax.portlet.faces.BridgeURLFactory;

public class BridgeNavigationHandlerImpl
extends BridgeNavigationHandlerCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(BridgeNavigationHandlerImpl.class);

    public BridgeNavigationHandlerImpl(NavigationHandler navigationHandler) {
        super(navigationHandler);
    }

    @Override
    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        int pos;
        logger.debug("fromAction=[{0}] outcome=[{1}]", new Object[]{fromAction, outcome});
        String queryString = null;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        String viewId = uiViewRoot.getViewId();
        if (viewId != null && (pos = viewId.indexOf("?")) > 0) {
            queryString = viewId.substring(pos);
            viewId = viewId.substring(0, pos);
            uiViewRoot.setViewId(viewId);
        }
        NavigationCase navigationCase = this.getNavigationCase(facesContext, fromAction, outcome);
        this.getWrappedNavigationHandler().handleNavigation(facesContext, fromAction, outcome);
        if (queryString != null) {
            uiViewRoot.setViewId(viewId.concat(queryString));
        }
        if (navigationCase != null) {
            ExternalContext externalContext;
            PortletResponse portletResponse;
            String toViewId;
            Iterator itr = facesContext.getMessages();
            while (itr.hasNext()) {
                FacesMessage facesMessage = (FacesMessage)itr.next();
                if (!facesMessage.getDetail().contains("Unable to find matching navigation case")) continue;
                logger.warn("Removed bogus FacesMessage caused by http://jira.icesoft.org/browse/ICE-7996");
                itr.remove();
            }
            if (!navigationCase.isRedirect() && (toViewId = navigationCase.getToViewId(facesContext)) != null && (portletResponse = (PortletResponse)(externalContext = facesContext.getExternalContext()).getResponse()) instanceof StateAwareResponse) {
                PortletContext portletContext = (PortletContext)externalContext.getContext();
                BridgeURLFactory bridgeURLFactory = (BridgeURLFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BridgeURLFactory.class);
                try {
                    String windowState;
                    BridgeURL bridgeActionURL = bridgeURLFactory.getBridgeActionURL(facesContext, toViewId);
                    BridgeNavigationCaseImpl bridgeNavigationCase = new BridgeNavigationCaseImpl(navigationCase);
                    String portletMode = bridgeNavigationCase.getPortletMode();
                    if (portletMode != null) {
                        bridgeActionURL.setParameter("javax.portlet.faces.PortletMode", portletMode);
                    }
                    if ((windowState = bridgeNavigationCase.getWindowState()) != null) {
                        bridgeActionURL.setParameter("javax.portlet.faces.WindowState", windowState);
                    }
                    PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                    BridgeNavigationUtil.navigate(portletRequest, (StateAwareResponse)portletResponse, bridgeActionURL.getParameterMap());
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    @Override
    public void handleNavigation(FacesContext facesContext, PortletMode fromPortletMode, PortletMode toPortletMode) {
        if (fromPortletMode != null && !fromPortletMode.equals((Object)toPortletMode)) {
            logger.debug("fromPortletMode=[{0}] toPortletMode=[{1}]", new Object[]{fromPortletMode, toPortletMode});
            String currentViewId = facesContext.getViewRoot().getViewId();
            PortletConfig portletConfig = RequestMapUtil.getPortletConfig(facesContext);
            Map<String, String> defaultViewIdMap = ViewUtil.getDefaultViewIdMap(portletConfig);
            String portletModeViewId = defaultViewIdMap.get(toPortletMode.toString());
            if (currentViewId != null && portletModeViewId != null && !currentViewId.equals(portletModeViewId)) {
                logger.debug("Navigating to viewId=[{0}]", new Object[]{portletModeViewId});
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                UIViewRoot viewRoot = viewHandler.createView(facesContext, portletModeViewId);
                if (viewRoot != null) {
                    facesContext.setViewRoot(viewRoot);
                    this.partialViewContextRenderAll(facesContext);
                }
            }
        }
    }
}

