/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.internal.PortletConfigParamUtil;
import com.liferay.faces.util.config.ConfigParam;
import com.liferay.faces.util.config.WebConfigParam;
import com.liferay.faces.util.helper.BooleanHelper;
import java.util.Set;
import javax.portlet.PortletConfig;

public enum PortletConfigParam implements ConfigParam<PortletConfig>
{
    BridgeRequestScopeActionEnabled(false, "javax.portlet.faces.BRIDGE_REQUEST_SCOPE_ACTION_ENABLED", "com.liferay.faces.bridge.bridgeRequestScopePreserved"),
    BridgeRequestScopeAjaxEnabled(false, "javax.portlet.faces.BRIDGE_REQUEST_SCOPE_AJAX_ENABLED", "com.liferay.faces.bridge.bridgeRequestScopeAjaxEnabled"),
    BridgeRequestScopeInitialCacheCapacity(16, "com.liferay.faces.bridge.INITIAL_MANAGED_REQUEST_SCOPES"),
    BridgeRequestScopeMaxCacheCapacity(100, "javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES"),
    ContainerAbleToSetHttpStatusCode(false, "com.liferay.faces.bridge.containerAbleToSetHttpStatusCode", "org.portletfaces.bridge.containerAbleToSetHttpStatusCode"),
    DefaultRenderKitId(null, "javax.portlet.faces.defaultRenderKitId"),
    ManageIncongruities(true, "com.liferay.faces.bridge.manageIncongruities"),
    PreferPreDestroy(true, "com.liferay.faces.bridge.preferPreDestroy", "org.portletfaces.bridge.preferPreDestroy"),
    PreserveActionParams(false, "javax.portlet.faces.preserveActionParams"),
    RenderRedirectEnabled(false, "com.liferay.faces.bridge.renderRedirectEnabled"),
    ResourceBufferSize(1024, "com.liferay.faces.bridge.resourceBufferSize", "org.portletfaces.bridge.resourceBufferSize"),
    UploadedFilesDir(WebConfigParam.UploadedFilesDir.getDefaultStringValue(), WebConfigParam.UploadedFilesDir.getName(), "com.liferay.faces.bridge.uploadedFilesDir", "javax.faces.UPLOADED_FILES_DIR"),
    UploadedFileMaxSize(WebConfigParam.UploadedFileMaxSize.getDefaultLongValue(), WebConfigParam.UploadedFileMaxSize.getName(), "com.liferay.faces.bridge.uploadedFileMaxSize", "javax.faces.UPLOADED_FILE_MAX_SIZE"),
    ViewIdParameterEnabled(true, "com.liferay.faces.bridge.jsfBridgeViewIdParameterEnabled"),
    ViewIdRenderParameterEnabled(true, "com.liferay.faces.bridge.viewIdRenderParameterEnabled"),
    ViewIdRenderParameterName("_facesViewIdRender", "com.liferay.faces.bridge.viewIdRenderParameterName"),
    ViewIdResourceParameterEnabled(true, "com.liferay.faces.bridge.viewIdResourceParameterEnabled"),
    ViewIdResourceParameterName("_facesViewIdResource", "com.liferay.faces.bridge.viewIdResourceParameterName"),
    ViewParametersEnabled(true, "com.liferay.faces.bridge.viewParametersEnabled"),
    ViewPathParameterEnabled(true, "com.liferay.faces.bridge.jsfBridgeViewPathParameterEnabled");

    private final String name;
    private final String alternateName;
    private final Set<String> names;
    private final boolean defaultBooleanValue;
    private final String defaultStringValue;
    private final int defaultIntegerValue;
    private final long defaultLongValue;

    private PortletConfigParam(int defaultIntegerValue, String ... names) {
        this.name = names[0];
        this.alternateName = PortletConfigParamUtil.getAlternateName(names);
        this.names = PortletConfigParamUtil.asInsertionOrderedSet(names);
        this.defaultBooleanValue = defaultIntegerValue != 0;
        this.defaultIntegerValue = defaultIntegerValue;
        this.defaultLongValue = defaultIntegerValue;
        this.defaultStringValue = Integer.toString(defaultIntegerValue);
    }

    private PortletConfigParam(long defaultLongValue, String ... names) {
        this.name = names[0];
        this.alternateName = PortletConfigParamUtil.getAlternateName(names);
        this.names = PortletConfigParamUtil.asInsertionOrderedSet(names);
        boolean bl = this.defaultBooleanValue = defaultLongValue != 0L;
        this.defaultIntegerValue = defaultLongValue < Integer.MIN_VALUE ? Integer.MIN_VALUE : (defaultLongValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)defaultLongValue);
        this.defaultLongValue = defaultLongValue;
        this.defaultStringValue = Long.toString(defaultLongValue);
    }

    private PortletConfigParam(String defaultStringValue, String ... names) {
        this.name = names[0];
        this.alternateName = PortletConfigParamUtil.getAlternateName(names);
        this.names = PortletConfigParamUtil.asInsertionOrderedSet(names);
        if (BooleanHelper.isTrueToken((String)defaultStringValue)) {
            this.defaultBooleanValue = true;
            this.defaultIntegerValue = 1;
            this.defaultLongValue = 1L;
        } else {
            this.defaultBooleanValue = false;
            this.defaultIntegerValue = 0;
            this.defaultLongValue = 0L;
        }
        this.defaultStringValue = defaultStringValue;
    }

    private PortletConfigParam(boolean defaultBooleanValue, String ... names) {
        this.name = names[0];
        this.alternateName = PortletConfigParamUtil.getAlternateName(names);
        this.names = PortletConfigParamUtil.asInsertionOrderedSet(names);
        this.defaultBooleanValue = defaultBooleanValue;
        if (defaultBooleanValue) {
            this.defaultIntegerValue = 1;
            this.defaultLongValue = 1L;
            this.defaultStringValue = Boolean.TRUE.toString();
        } else {
            this.defaultIntegerValue = 0;
            this.defaultLongValue = 0L;
            this.defaultStringValue = Boolean.FALSE.toString();
        }
    }

    public String getAlternateName() {
        return this.alternateName;
    }

    public boolean getBooleanValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getBooleanValue(portletConfig, this);
    }

    public String getConfiguredValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getConfiguredValue(portletConfig, this);
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultBooleanValue;
    }

    public int getDefaultIntegerValue() {
        return this.defaultIntegerValue;
    }

    public long getDefaultLongValue() {
        return this.defaultLongValue;
    }

    public String getDefaultStringValue() {
        return this.defaultStringValue;
    }

    public int getIntegerValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getIntegerValue(portletConfig, this);
    }

    public long getLongValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getLongValue(portletConfig, this);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public String getStringValue(PortletConfig portletConfig) {
        return PortletConfigParamUtil.getStringValue(portletConfig, this);
    }

    public boolean isConfigured(PortletConfig portletConfig) {
        return PortletConfigParamUtil.isSpecified(portletConfig, this);
    }
}

