/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.servlet;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.portlet.faces.GenericFacesPortlet;

public class BridgeExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(BridgeExtension.class);

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(GenericFacesPortlet.class), null);
    }

    private <T> void step2ProcessAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        if (GenericFacesPortlet.class.isAssignableFrom(javaClass) && !annotatedType.isAnnotationPresent(ApplicationScoped.class)) {
            HashSet<Annotation> annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
            annotations.add(new ApplicationScopedAnnotation());
            if (!annotations.equals(annotatedType.getAnnotations())) {
                processAnnotatedType.setAnnotatedType(new ModifiedAnnotatedType(annotatedType, annotations, annotatedType.getTypeClosure()));
                logger.info("Automatically added @ApplicationScoped annotation to GenericFacesPortlet.");
            }
        }
    }

    private static final class ModifiedAnnotatedType<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> annotatedType;
        private final Set<Annotation> annotations;
        private final Set<Type> types;

        public ModifiedAnnotatedType(AnnotatedType<X> annotatedType, Set<Annotation> annotations, Set<Type> types) {
            this.annotatedType = annotatedType;
            this.annotations = Collections.unmodifiableSet(annotations);
            this.types = Collections.unmodifiableSet(types);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation annotation : this.annotations) {
                Class<? extends Annotation> curAnnotationType = annotation.annotationType();
                if (!curAnnotationType.equals(annotationType)) continue;
                return (T)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Type getBaseType() {
            return this.annotatedType.getBaseType();
        }

        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.annotatedType.getConstructors();
        }

        public Set<AnnotatedField<? super X>> getFields() {
            return this.annotatedType.getFields();
        }

        public Class<X> getJavaClass() {
            return this.annotatedType.getJavaClass();
        }

        public Set<AnnotatedMethod<? super X>> getMethods() {
            return this.annotatedType.getMethods();
        }

        public Set<Type> getTypeClosure() {
            return this.types;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            for (Annotation annotation : this.annotations) {
                Class<? extends Annotation> curAnnotationType = annotation.annotationType();
                if (!curAnnotationType.equals(annotationType)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class ApplicationScopedAnnotation
    implements Annotation {
        private ApplicationScopedAnnotation() {
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ApplicationScoped.class;
        }
    }
}

