/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.ResourceRichFacesImpl;
import com.liferay.faces.util.application.FilteredResourceBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceRichFacesPackedJSImpl
extends FilteredResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRichFacesPackedJSImpl.class);
    private Resource wrappedResource;

    public ResourceRichFacesPackedJSImpl(Resource wrappedResource) {
        this.wrappedResource = new ResourceRichFacesImpl(wrappedResource);
    }

    public Resource getWrapped() {
        return this.wrappedResource;
    }

    protected String filter(String javaScriptText) {
        String token = "this.form.attr(\"action\", originalAction + delimiter + UID + \"=\" + this.loadableItem.uid);";
        int pos = javaScriptText.indexOf(token);
        if (pos > 0) {
            logger.debug("Found first token in packed.js");
            StringBuilder buf = new StringBuilder();
            buf.append(javaScriptText.substring(0, pos));
            buf.append("this.form.attr(\"action\", this.form.children(\"input[name&='javax.faces.encodedURL']\").val() + delimiter + UID + \"=\" + this.loadableItem.uid);");
            buf.append(javaScriptText.substring(pos + token.length() + 1));
            javaScriptText = buf.toString();
        }
        javaScriptText = this.replaceToken(javaScriptText, "this.fileUpload.form.attr(\"action\")", "this.fileUpload.form.children(\"input[name$='javax.faces.encodedURL']\").val()");
        javaScriptText = this.prependToken(javaScriptText, "if (jQuery.atmosphere.requests.length > 0) {", "if (!jQuery.atmosphere) { return; }; ");
        javaScriptText = this.prependToken(javaScriptText, "jQuery.atmosphere.unsubscribe();", "if (!jQuery.atmosphere) { return; }; ");
        javaScriptText = this.prependToken(javaScriptText, "$.atmosphere.unsubscribe();", "if (!$.atmosphere) { return; }; ");
        token = "this.fileUpload.form.find(\"input[name='javax.faces.ViewState']\").val();";
        pos = javaScriptText.indexOf(token);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Product JSF = ProductFactory.getProductInstance((ExternalContext)externalContext, (Product.Name)Product.Name.JSF);
        int JSF_MAJOR_VERSION = JSF.getMajorVersion();
        if ((JSF_MAJOR_VERSION > 2 || JSF_MAJOR_VERSION == 2 && JSF.getMinorVersion() >= 3) && pos > 0) {
            String fixedMatchingText;
            String matchingText;
            logger.debug("Found javax.faces.ViewState selector in packed.js");
            javaScriptText = this.replaceToken(javaScriptText, token, "'',vsElem=this.fileUpload.form.find(\"input[name$='javax.faces.ViewState']\"),paramPrefix=vsElem.attr('name').substring(0,vsElem.attr('name').indexOf('javax.faces.ViewState'));");
            javaScriptText = this.replaceToken(javaScriptText, "append(\"javax.faces.ViewState\",", "append(vsElem.attr('name'),vsElem.val()+");
            javaScriptText = this.replaceToken(javaScriptText, "javax.faces.partial.ajax=", "\" + paramPrefix + \"javax.faces.partial.ajax=");
            javaScriptText = this.replaceToken(javaScriptText, "javax.faces.partial.execute=", "\" + paramPrefix + \"javax.faces.partial.execute=");
            javaScriptText = this.replaceToken(javaScriptText, "javax.faces.ViewState=", "\" + paramPrefix + \"javax.faces.ViewState=");
            javaScriptText = this.replaceToken(javaScriptText, "javax.faces.source=", "\" + paramPrefix + \"javax.faces.source=");
            javaScriptText = this.replaceToken(javaScriptText, "org.richfaces.ajax.component=", "\" + paramPrefix + \"org.richfaces.ajax.component=");
            String regEx = "\\w+\\s*=\\s*\\w+\\s*\\+\\s*\\w+\\s*\\+\\s*\\w+\\s*\\+\\s*\"=\"\\s*\\+\\s*this.uid";
            Matcher matcher = Pattern.compile(regEx).matcher(javaScriptText);
            if (matcher.find()) {
                matchingText = javaScriptText.substring(matcher.start(), matcher.end());
                String[] parts = matchingText.split("\\+");
                fixedMatchingText = parts[0] + "+" + parts[1] + "+ paramPrefix +" + parts[2] + "+" + parts[3] + "+" + parts[4];
                javaScriptText = javaScriptText.substring(0, matcher.start()) + fixedMatchingText + javaScriptText.substring(matcher.end());
            } else {
                logger.warn("Unable fix the javax.faces.ViewState value because newAction can't be found");
            }
            regEx = "javax.faces.ViewState\\=\"\\s*\\+\\s*encodeURIComponent[(]\\w+[)]";
            matcher = Pattern.compile(regEx).matcher(javaScriptText);
            if (matcher.find()) {
                matchingText = javaScriptText.substring(matcher.start(), matcher.end());
                int openParenPos = matchingText.indexOf("(");
                fixedMatchingText = matchingText.substring(0, openParenPos) + "(vsElem.val())";
                javaScriptText = javaScriptText.substring(0, matcher.start()) + fixedMatchingText + javaScriptText.substring(matcher.end());
            } else {
                logger.warn("Unable to find and fix encodeURIComponent(viewState)");
            }
        }
        return javaScriptText;
    }

    private String prependToken(String javaScriptText, String token, String prependText) {
        int pos = javaScriptText.indexOf(token);
        if (pos > 0) {
            logger.debug("Found token=[{0}] in packed.js prependText=[{1}]", new Object[]{token, prependText});
            StringBuilder buf = new StringBuilder();
            buf.append(javaScriptText.substring(0, pos));
            buf.append(prependText);
            buf.append(javaScriptText.substring(pos));
            javaScriptText = buf.toString();
        }
        return javaScriptText;
    }

    private String replaceToken(String javaScriptText, String token, String replacementText) {
        int pos = javaScriptText.indexOf(token);
        if (pos > 0) {
            logger.debug("Found token=[{0}] in packed.js replacementText=[{1}]", new Object[]{token, replacementText});
            StringBuilder buf = new StringBuilder();
            buf.append(javaScriptText.substring(0, pos));
            buf.append(replacementText);
            buf.append(javaScriptText.substring(pos + token.length()));
            javaScriptText = buf.toString();
        }
        return javaScriptText;
    }
}

