/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portlet.component.baseurl.internal;

import com.liferay.faces.bridge.util.internal.XMLUtil;
import com.liferay.faces.portlet.component.baseurl.internal.BaseURLRendererBase;
import com.liferay.faces.portlet.component.param.Param;
import com.liferay.faces.portlet.component.property.Property;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.BaseURL;
import javax.portlet.PortletSecurityException;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public abstract class BaseURLRenderer
extends BaseURLRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        BaseURL baseURL = this.createBaseURL(facesContext, uiComponent);
        Boolean secure = this.getSecure(uiComponent);
        if (secure != null) {
            try {
                baseURL.setSecure(secure.booleanValue());
            }
            catch (PortletSecurityException e) {
                throw new IOException(e);
            }
        }
        this.processParamChildren(uiComponent, baseURL);
        this.processPropertyChildren(uiComponent, baseURL);
        String varName = this.getVar(uiComponent);
        String url = baseURL.toString();
        if (this.isEscapeXml(uiComponent)) {
            url = XMLUtil.escapeXML(url);
        }
        if (varName == null) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.write(url);
        } else {
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            requestMap.put(varName, url);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected abstract BaseURL createBaseURL(FacesContext var1, UIComponent var2) throws IOException;

    protected abstract Boolean getSecure(UIComponent var1);

    protected abstract String getVar(UIComponent var1);

    protected abstract boolean isEscapeXml(UIComponent var1);

    protected void processParamChildren(UIComponent uiComponent, BaseURL baseURL) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(baseURL.getParameterMap());
        HashMap initialParameterMap = new HashMap(parameterMap);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean RESOURCE_PHASE = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext).equals((Object)Bridge.PortletPhase.RESOURCE_PHASE);
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof Param)) continue;
            Param portletParam = (Param)child;
            String name = portletParam.getName();
            String value = portletParam.getValue();
            if (parameterMap.containsKey(name)) {
                boolean REMOVE_EMPTY_PARAMETER;
                boolean PARAM_SET_BY_PORTLET_CONTAINER = initialParameterMap.containsKey(name);
                boolean bl = REMOVE_EMPTY_PARAMETER = !RESOURCE_PHASE || !PARAM_SET_BY_PORTLET_CONTAINER;
                if ("".equals(value) && REMOVE_EMPTY_PARAMETER) {
                    parameterMap.remove(name);
                    continue;
                }
                if ("".equals(value) && !REMOVE_EMPTY_PARAMETER) continue;
                String[] paramValueArray = (String[])parameterMap.get(name);
                String[] newParamValueArray = new String[paramValueArray.length + 1];
                System.arraycopy(paramValueArray, 0, newParamValueArray, 0, paramValueArray.length);
                newParamValueArray[newParamValueArray.length - 1] = value;
                parameterMap.put(name, newParamValueArray);
                continue;
            }
            parameterMap.put(name, new String[]{value});
        }
        baseURL.setParameters(parameterMap);
    }

    protected void processPropertyChildren(UIComponent uiComponent, BaseURL baseURL) {
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            Property portletProperty;
            String value;
            if (!(child instanceof Property) || (value = (portletProperty = (Property)child).getValue()) == null) continue;
            baseURL.addProperty(portletProperty.getName(), value);
        }
    }
}

