/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.util.internal;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLUtil {
    public static String escapeXML(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            String replacement = null;
            if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '\"') {
                replacement = "&#34;";
            } else if (c == '\'') {
                replacement = "&#39;";
            } else if (c == '\u00bb') {
                replacement = "&#187;";
            } else if (c == '\u2013') {
                replacement = "&#x2013;";
            } else if (c == '\u2014') {
                replacement = "&#x2014;";
            } else if (c == '\u2028') {
                replacement = "&#x2028;";
            } else if (!XMLUtil._isValidXmlCharacter(c) || XMLUtil._isUnicodeCompatibilityCharacter(c)) {
                replacement = " ";
            }
            if (replacement == null) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (i > lastReplacementIndex) {
                sb.append(text.substring(lastReplacementIndex, i));
            }
            sb.append(replacement);
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return text;
        }
        if (lastReplacementIndex < text.length()) {
            sb.append(text.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    private static boolean _isUnicodeCompatibilityCharacter(char c) {
        return c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufdef';
    }

    private static boolean _isValidXmlCharacter(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || Character.isLowSurrogate(c) || Character.isHighSurrogate(c);
    }

    private XMLUtil() {
        throw new AssertionError();
    }

    public static String elementToString(Node element) {
        return XMLUtil.elementToString(element, true);
    }

    public static String elementToString(Node element, boolean escapeAttributeValues) {
        StringBuilder buf = new StringBuilder();
        XMLUtil.appendElementRecurse(buf, element, escapeAttributeValues);
        return buf.toString();
    }

    public static String nodeToString(Node node) {
        String textContent = node.getTextContent();
        StringBuilder buf = new StringBuilder();
        if (textContent != null) {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 3: {
                    buf.append(textContent);
                    break;
                }
                case 8: {
                    buf.append("<!--");
                    buf.append(textContent);
                    buf.append("-->");
                    break;
                }
                case 4: {
                    buf.append("<![CDATA[");
                    buf.append(textContent);
                    buf.append("]]>");
                    break;
                }
                case 1: {
                    throw new IllegalArgumentException("Call XMLUtil.elementToString() to obtain an element as a string.");
                }
                default: {
                    throw new IllegalArgumentException("Node type [" + nodeType + "] not supported.");
                }
            }
        }
        return buf.toString();
    }

    private static void appendElementRecurse(StringBuilder buf, Node element, boolean escapeAttributeValues) {
        buf.append("<");
        String nodeName = element.getNodeName();
        buf.append(nodeName);
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            buf.append(" ");
            buf.append(attribute.getNodeName());
            buf.append("=\"");
            String nodeValue = attribute.getNodeValue();
            if (nodeValue != null) {
                if (escapeAttributeValues) {
                    buf.append(XMLUtil.escapeXML(nodeValue));
                } else {
                    buf.append(nodeValue);
                }
            }
            buf.append("\"");
        }
        buf.append(">");
        if (!nodeName.equals("link")) {
            if (element.hasChildNodes()) {
                NodeList childNodes = element.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    short nodeType = node.getNodeType();
                    if (nodeType == 1) {
                        XMLUtil.appendElementRecurse(buf, node, escapeAttributeValues);
                        continue;
                    }
                    buf.append(XMLUtil.nodeToString(node));
                }
            } else {
                String textContent = element.getTextContent();
                if (textContent != null) {
                    buf.append(textContent);
                }
            }
            buf.append("</");
            buf.append(nodeName);
            buf.append(">");
        }
    }
}

