/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.primefaces.internal;

import com.liferay.faces.bridge.component.internal.ResourceComponent;
import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadRendererBridgeImpl;
import com.liferay.faces.bridge.renderkit.html_basic.internal.InlineScript;
import com.liferay.faces.bridge.renderkit.primefaces.internal.FacesContextPrimeFacesHeadImpl;
import com.liferay.faces.bridge.renderkit.primefaces.internal.PrimeFacesHeadResponseWriter;
import com.liferay.faces.bridge.renderkit.primefaces.internal.ResourceCapturingUIViewRoot;
import com.liferay.faces.bridge.util.internal.TCCLUtil;
import com.liferay.faces.bridge.util.internal.URLUtil;
import com.liferay.faces.util.lang.ThreadSafeAccessor;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class HeadRendererPrimeFacesImpl
extends HeadRendererBridgeImpl {
    private static final Logger logger = LoggerFactory.getLogger(HeadRendererPrimeFacesImpl.class);
    private static final String MOBILE_COMPONENT_RESOURCES_KEY = HeadRendererPrimeFacesImpl.class.getName() + "_mobileComponentResources";
    private static final String PRIMEFACES_THEME_PREFIX = "primefaces-";
    private static final String PRIMEFACES_THEME_RESOURCE_NAME = "theme.css";
    private final PrimeFacesHeadRendererAccessor primeFacesHeadRendererAccessor = new PrimeFacesHeadRendererAccessor();
    private final PrimeFacesMobileHeadRendererAccessor primeFacesMobileHeadRendererAccessor = new PrimeFacesMobileHeadRendererAccessor();

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIViewRoot originalUIViewRoot = facesContext.getViewRoot();
        if (this.isMobile(facesContext)) {
            List componentResources = originalUIViewRoot.getComponentResources(facesContext, "head");
            ArrayList<UIComponent> resourcesToRemove = new ArrayList<UIComponent>();
            for (UIComponent componentResource : componentResources) {
                if (this.isComponentResourceSuppressedWhenMobile(componentResource)) {
                    componentResource.setRendered(false);
                    continue;
                }
                if (!this.isMobileComponentResource(componentResource)) continue;
                resourcesToRemove.add(componentResource);
            }
            for (UIComponent resourceToRemove : resourcesToRemove) {
                originalUIViewRoot.removeComponentResource(facesContext, resourceToRemove, "head");
            }
        }
        FacesContextPrimeFacesHeadImpl primeFacesContext = new FacesContextPrimeFacesHeadImpl(facesContext);
        ResponseWriter origResponseWriter = primeFacesContext.getResponseWriter();
        PrimeFacesHeadResponseWriter primeFacesHeadResponseWriter = new PrimeFacesHeadResponseWriter();
        primeFacesContext.setResponseWriter(primeFacesHeadResponseWriter);
        ResourceCapturingUIViewRoot resourceCapturingUIViewRoot = new ResourceCapturingUIViewRoot();
        primeFacesContext.setViewRoot(resourceCapturingUIViewRoot);
        Renderer primeFacesHeadRenderer = this.getPrimeFacesHeadRenderer(facesContext);
        primeFacesHeadRenderer.encodeBegin((FacesContext)primeFacesContext, uiComponent);
        primeFacesContext.setViewRoot(originalUIViewRoot);
        primeFacesContext.setResponseWriter(origResponseWriter);
        List<UIComponent> capturedResources = resourceCapturingUIViewRoot.getCapturedComponentResources("head");
        ArrayList<UIComponent> capturedMobileResources = new ArrayList<UIComponent>();
        List<String> externalResourceURLs = primeFacesHeadResponseWriter.getExternalResourceURLs();
        if (externalResourceURLs.size() > 0) {
            ExternalContext externalContext = facesContext.getExternalContext();
            String resourceNameParam = externalContext.encodeNamespace("javax.faces.resource");
            String libraryNameParam = externalContext.encodeNamespace("ln");
            for (String externalResourceURL : externalResourceURLs) {
                String resourceName = null;
                String libraryName = null;
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                String characterEncoding = responseWriter.getCharacterEncoding();
                Map<String, String[]> parsedParameterMapValuesArray = URLUtil.parseParameterMapValuesArray(externalResourceURL, characterEncoding);
                if (parsedParameterMapValuesArray != null) {
                    String[] libraryNameParamValues;
                    String[] resourceNameParamValues = parsedParameterMapValuesArray.get(resourceNameParam);
                    if (resourceNameParamValues == null || resourceNameParamValues.length < 1) {
                        resourceNameParamValues = parsedParameterMapValuesArray.get("javax.faces.resource");
                    }
                    if (resourceNameParamValues != null && resourceNameParamValues.length > 0) {
                        resourceName = resourceNameParamValues[0];
                    }
                    if (resourceName == null) {
                        int indexOfResource = externalResourceURL.indexOf("javax.faces.resource/");
                        int indexOfQuery = externalResourceURL.indexOf("?");
                        if (indexOfResource > -1) {
                            int indexOfResourceName = indexOfResource + "javax.faces.resource/".length();
                            resourceName = indexOfQuery > -1 ? externalResourceURL.substring(indexOfResourceName, indexOfQuery) : externalResourceURL.substring(indexOfResourceName);
                        }
                    }
                    if ((libraryNameParamValues = parsedParameterMapValuesArray.get(libraryNameParam)) == null || libraryNameParamValues.length < 1) {
                        libraryNameParamValues = parsedParameterMapValuesArray.get("ln");
                    }
                    if (libraryNameParamValues != null && libraryNameParamValues.length > 0) {
                        libraryName = libraryNameParamValues[0];
                    }
                }
                if (resourceName == null || libraryName == null) continue;
                if (resourceName.equals(PRIMEFACES_THEME_RESOURCE_NAME) && libraryName.startsWith(PRIMEFACES_THEME_PREFIX)) {
                    ResourceComponent primefacesThemeResource = new ResourceComponent(facesContext, resourceName, libraryName, externalContext.encodeNamespace(""));
                    Map facesContextAttributes = facesContext.getAttributes();
                    facesContextAttributes.put("primefacesTheme", primefacesThemeResource);
                    continue;
                }
                Application application = facesContext.getApplication();
                ResourceHandler resourceHandler = application.getResourceHandler();
                UIComponent resource = application.createComponent("javax.faces.Output");
                String rendererType = resourceHandler.getRendererTypeForResourceName(resourceName);
                resource.setRendererType(rendererType);
                resource.setTransient(true);
                resource.getAttributes().put("name", resourceName);
                resource.getAttributes().put("library", libraryName);
                resource.getAttributes().put("target", "head");
                if (this.isMobile(facesContext)) {
                    if (this.isMobileComponentResource(resourceName, libraryName)) {
                        capturedMobileResources.add(resource);
                        continue;
                    }
                    if (this.isComponentResourceSuppressedWhenMobile(resourceName, libraryName)) {
                        resource.setRendered(false);
                    }
                    capturedResources.add(resource);
                    continue;
                }
                capturedResources.add(resource);
            }
        }
        for (UIComponent componentResource : capturedResources) {
            originalUIViewRoot.addComponentResource(facesContext, componentResource, "head");
        }
        List<InlineScript> inlineScripts = primeFacesHeadResponseWriter.getInlineScripts();
        if (!inlineScripts.isEmpty()) {
            if (this.isMobile(facesContext)) {
                InlineScript mobileInlineScript = inlineScripts.remove(0);
                ListIterator<Object> listIterator = capturedMobileResources.listIterator();
                while (listIterator.hasNext()) {
                    UIComponent mobileComponentResource = (UIComponent)listIterator.next();
                    Map attributes = mobileComponentResource.getAttributes();
                    String name = (String)attributes.get("name");
                    if (!name.equals("jquery/jquery.js")) continue;
                    listIterator.add((Object)mobileInlineScript);
                    break;
                }
            }
            for (InlineScript primeFacesInlineScript : inlineScripts) {
                originalUIViewRoot.addComponentResource(facesContext, (UIComponent)primeFacesInlineScript, "head");
            }
        }
        if (this.isMobile(facesContext)) {
            Map attributes = facesContext.getAttributes();
            attributes.put(MOBILE_COMPONENT_RESOURCES_KEY, capturedMobileResources);
        }
        super.encodeBegin(facesContext, uiComponent);
    }

    @Override
    protected List<UIComponent> getFirstResources(FacesContext facesContext, UIComponent uiComponent) {
        Map facesContextAttributes;
        ResourceComponent primefacesThemeResource;
        List<UIComponent> firstResources = super.getFirstResources(facesContext, uiComponent);
        if (firstResources == null) {
            firstResources = new ArrayList<UIComponent>();
        }
        if ((primefacesThemeResource = (ResourceComponent)((Object)(facesContextAttributes = facesContext.getAttributes()).remove("primefacesTheme"))) != null) {
            firstResources.add((UIComponent)primefacesThemeResource);
        }
        return firstResources;
    }

    @Override
    protected List<UIComponent> getMiddleResources(FacesContext facesContext, UIComponent uiComponent) {
        List<UIComponent> middleResources = super.getMiddleResources(facesContext, uiComponent);
        if (this.isMobile(facesContext)) {
            if (middleResources == null) {
                middleResources = new ArrayList<UIComponent>();
            }
            Map attributes = facesContext.getAttributes();
            List mobileComponentResources = (List)attributes.remove(MOBILE_COMPONENT_RESOURCES_KEY);
            middleResources.addAll(mobileComponentResources);
        }
        return middleResources;
    }

    private Renderer getPrimeFacesHeadRenderer(FacesContext facesContext) {
        if (this.isMobile(facesContext)) {
            return this.primeFacesMobileHeadRendererAccessor.computeValue(facesContext);
        }
        return this.primeFacesHeadRendererAccessor.computeValue(facesContext);
    }

    private boolean isComponentResourceSuppressedWhenMobile(UIComponent componentResource) {
        Map attributes = componentResource.getAttributes();
        String libraryName = (String)attributes.get("library");
        String resourceName = (String)attributes.get("name");
        return this.isComponentResourceSuppressedWhenMobile(resourceName, libraryName);
    }

    private boolean isComponentResourceSuppressedWhenMobile(String resourceName, String libraryName) {
        return !this.isMobileComponentResource(resourceName, libraryName) && "primefaces".equals(libraryName) && (resourceName.startsWith("jquery") || resourceName.startsWith("primefaces") || resourceName.startsWith("components") || resourceName.startsWith("core"));
    }

    private boolean isMobile(FacesContext facesContext) {
        String renderKitId;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            renderKitId = uiViewRoot.getRenderKitId();
        } else {
            Application application = facesContext.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            renderKitId = viewHandler.calculateRenderKitId(facesContext);
        }
        return "PRIMEFACES_MOBILE".equals(renderKitId);
    }

    private boolean isMobileComponentResource(UIComponent componentResource) {
        Map attributes = componentResource.getAttributes();
        String libraryName = (String)attributes.get("library");
        String resourceName = (String)attributes.get("name");
        return this.isMobileComponentResource(resourceName, libraryName);
    }

    private boolean isMobileComponentResource(String resourceName, String libraryName) {
        return "primefaces".equals(libraryName) && ("jquery/jquery.js".equals(resourceName) || "mobile/jquery-mobile.js".equals(resourceName) || "core.js".equals(resourceName) || "components-mobile.js".equals(resourceName));
    }

    private static final class PrimeFacesMobileHeadRendererAccessor
    extends ThreadSafeAccessor<Renderer, FacesContext> {
        private PrimeFacesMobileHeadRendererAccessor() {
        }

        protected Renderer computeValue(FacesContext facesContext) {
            Renderer primeFacesMobileHeadRenderer = null;
            try {
                Class<?> headRendererClass = TCCLUtil.loadClassFromContext(((Object)((Object)this)).getClass(), "org.primefaces.mobile.renderkit.HeadRenderer");
                primeFacesMobileHeadRenderer = (Renderer)headRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            return primeFacesMobileHeadRenderer;
        }
    }

    private static final class PrimeFacesHeadRendererAccessor
    extends ThreadSafeAccessor<Renderer, FacesContext> {
        private PrimeFacesHeadRendererAccessor() {
        }

        protected Renderer computeValue(FacesContext facesContext) {
            Renderer primeFacesHeadRenderer = null;
            try {
                Class<?> headRendererClass = TCCLUtil.loadClassFromContext(((Object)((Object)this)).getClass(), "org.primefaces.renderkit.HeadRenderer");
                primeFacesHeadRenderer = (Renderer)headRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            return primeFacesHeadRenderer;
        }
    }
}

