/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.context.map.internal.RequestCookieMapEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;

public class RequestCookieMap
implements Map<String, Object> {
    private Cookie[] cookies;

    public RequestCookieMap(Cookie[] cookies) {
        this.cookies = cookies;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean found = false;
        if (key != null) {
            String keyAsString = key.toString();
            if (this.cookies != null) {
                Cookie cookie;
                Cookie[] cookieArray = this.cookies;
                int n = cookieArray.length;
                for (int i = 0; i < n && !(found = (cookie = cookieArray[i]).getName().equals(keyAsString)); ++i) {
                }
            }
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                boolean bl = found = cookie == value;
                if (found) break;
            }
        }
        return found;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<RequestCookieMapEntry> entrySet = null;
        if (this.cookies != null) {
            entrySet = new HashSet<RequestCookieMapEntry>();
            for (Cookie cookie : this.cookies) {
                String cookieName = cookie.getName();
                RequestCookieMapEntry requestCookieMapEntry = new RequestCookieMapEntry(cookieName, cookie);
                entrySet.add(requestCookieMapEntry);
            }
        }
        return entrySet;
    }

    @Override
    public Cookie get(Object key) {
        Cookie value = null;
        if (key != null && this.cookies != null) {
            String keyAsString = key.toString();
            for (Cookie cookie : this.cookies) {
                if (!cookie.getName().equals(keyAsString)) continue;
                value = cookie;
                break;
            }
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.cookies == null || this.cookies.length == 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = null;
        if (this.cookies != null) {
            keySet = new HashSet<String>();
            for (Cookie cookie : this.cookies) {
                String cookieName = cookie.getName();
                keySet.add(cookieName);
            }
        }
        return keySet;
    }

    @Override
    public Cookie put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cookie remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        if (this.cookies != null) {
            size = this.cookies.length;
        }
        return size;
    }

    @Override
    public Collection<Object> values() {
        HashSet<Cookie> values = null;
        if (this.cookies != null) {
            values = new HashSet<Cookie>();
            for (Cookie cookie : this.cookies) {
                values.add(cookie);
            }
        }
        return values;
    }
}

